@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.RepositoryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Container Registry Repository Policy.
 * Note that currently only one policy may be applied to a repository.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.Repository;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ecr.RepositoryPolicy;
 * import com.pulumi.aws.ecr.RepositoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Repository("foo");
 *         final var foopolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("new policy")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions(
 *                     "ecr:GetDownloadUrlForLayer",
 *                     "ecr:BatchGetImage",
 *                     "ecr:BatchCheckLayerAvailability",
 *                     "ecr:PutImage",
 *                     "ecr:InitiateLayerUpload",
 *                     "ecr:UploadLayerPart",
 *                     "ecr:CompleteLayerUpload",
 *                     "ecr:DescribeRepositories",
 *                     "ecr:GetRepositoryPolicy",
 *                     "ecr:ListImages",
 *                     "ecr:DeleteRepository",
 *                     "ecr:BatchDeleteImage",
 *                     "ecr:SetRepositoryPolicy",
 *                     "ecr:DeleteRepositoryPolicy")
 *                 .build())
 *             .build());
 *         var foopolicyRepositoryPolicy = new RepositoryPolicy("foopolicyRepositoryPolicy", RepositoryPolicyArgs.builder()
 *             .repository(foo.name())
 *             .policy(foopolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Repository Policy using the repository name. For example:
 * ```sh
 *  $ pulumi import aws:ecr/repositoryPolicy:RepositoryPolicy example example
 * ```
 * @property policy The policy document. This is a JSON formatted string.
 * @property repository Name of the repository to apply the policy.
 */
public data class RepositoryPolicyArgs(
    public val policy: Output<String>? = null,
    public val repository: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.RepositoryPolicyArgs> {
    override fun toJava(): com.pulumi.aws.ecr.RepositoryPolicyArgs =
        com.pulumi.aws.ecr.RepositoryPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .repository(repository?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryPolicyArgs].
 */
@PulumiTagMarker
public class RepositoryPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var repository: Output<String>? = null

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("ysthgtsupkgalaby")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Name of the repository to apply the policy.
     */
    @JvmName("ldpwplxyojgjrtex")
    public suspend fun repository(`value`: Output<String>) {
        this.repository = value
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("sixqcdkbvtqwrbus")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Name of the repository to apply the policy.
     */
    @JvmName("qfgvhwxgbafbyhdp")
    public suspend fun repository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    internal fun build(): RepositoryPolicyArgs = RepositoryPolicyArgs(
        policy = policy,
        repository = repository,
    )
}
