@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.GetAuthorizationTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAuthorizationToken.
 * @property registryId AWS account ID of the ECR Repository. If not specified the default account is assumed.
 */
public data class GetAuthorizationTokenPlainArgs(
    public val registryId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.GetAuthorizationTokenPlainArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.GetAuthorizationTokenPlainArgs =
        com.pulumi.aws.ecr.inputs.GetAuthorizationTokenPlainArgs.builder()
            .registryId(registryId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthorizationTokenPlainArgs].
 */
@PulumiTagMarker
public class GetAuthorizationTokenPlainArgsBuilder internal constructor() {
    private var registryId: String? = null

    /**
     * @param value AWS account ID of the ECR Repository. If not specified the default account is assumed.
     */
    @JvmName("xgyyriobduihlbxi")
    public suspend fun registryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.registryId = mapped
    }

    internal fun build(): GetAuthorizationTokenPlainArgs = GetAuthorizationTokenPlainArgs(
        registryId = registryId,
    )
}
