@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.GetRepositoryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRepository.
 * @property name Name of the ECR Repository.
 * @property registryId Registry ID where the repository was created.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetRepositoryPlainArgs(
    public val name: String,
    public val registryId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.GetRepositoryPlainArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.GetRepositoryPlainArgs =
        com.pulumi.aws.ecr.inputs.GetRepositoryPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .registryId(registryId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetRepositoryPlainArgs].
 */
@PulumiTagMarker
public class GetRepositoryPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var registryId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the ECR Repository.
     */
    @JvmName("dotttepmirmfdwgg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Registry ID where the repository was created.
     */
    @JvmName("qyeeehjnhwvreovq")
    public suspend fun registryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.registryId = mapped
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("erhlhxpbmucopasf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource.
     */
    @JvmName("fimletrwnmtyfldt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetRepositoryPlainArgs = GetRepositoryPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        registryId = registryId,
        tags = tags,
    )
}
