@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property repositoryFilters One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
 * @property scanFrequency The frequency that scans are performed at for a private registry. Can be `SCAN_ON_PUSH`, `CONTINUOUS_SCAN`, or `MANUAL`.
 */
public data class RegistryScanningConfigurationRuleArgs(
    public val repositoryFilters: Output<List<RegistryScanningConfigurationRuleRepositoryFilterArgs>>,
    public val scanFrequency: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs =
        com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs.builder()
            .repositoryFilters(
                repositoryFilters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scanFrequency(scanFrequency.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryScanningConfigurationRuleArgs].
 */
@PulumiTagMarker
public class RegistryScanningConfigurationRuleArgsBuilder internal constructor() {
    private var repositoryFilters:
        Output<List<RegistryScanningConfigurationRuleRepositoryFilterArgs>>? = null

    private var scanFrequency: Output<String>? = null

    /**
     * @param value One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
     */
    @JvmName("ttsxjewnbyduosxr")
    public suspend
    fun repositoryFilters(`value`: Output<List<RegistryScanningConfigurationRuleRepositoryFilterArgs>>) {
        this.repositoryFilters = value
    }

    @JvmName("pwufsjlbauvrjvoe")
    public suspend fun repositoryFilters(
        vararg
        values: Output<RegistryScanningConfigurationRuleRepositoryFilterArgs>,
    ) {
        this.repositoryFilters = Output.all(values.asList())
    }

    /**
     * @param values One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
     */
    @JvmName("fplwobmeyubjudut")
    public suspend
    fun repositoryFilters(values: List<Output<RegistryScanningConfigurationRuleRepositoryFilterArgs>>) {
        this.repositoryFilters = Output.all(values)
    }

    /**
     * @param value The frequency that scans are performed at for a private registry. Can be `SCAN_ON_PUSH`, `CONTINUOUS_SCAN`, or `MANUAL`.
     */
    @JvmName("fpknuxcprildwlnt")
    public suspend fun scanFrequency(`value`: Output<String>) {
        this.scanFrequency = value
    }

    /**
     * @param value One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
     */
    @JvmName("jqmmkjpuqfyurdfw")
    public suspend
    fun repositoryFilters(`value`: List<RegistryScanningConfigurationRuleRepositoryFilterArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryFilters = mapped
    }

    /**
     * @param argument One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
     */
    @JvmName("bvbvirhlybkpwwmo")
    public suspend
    fun repositoryFilters(argument: List<suspend RegistryScanningConfigurationRuleRepositoryFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegistryScanningConfigurationRuleRepositoryFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.repositoryFilters = mapped
    }

    /**
     * @param argument One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
     */
    @JvmName("pqumeovbdfjenebd")
    public suspend fun repositoryFilters(
        vararg
        argument: suspend RegistryScanningConfigurationRuleRepositoryFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RegistryScanningConfigurationRuleRepositoryFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.repositoryFilters = mapped
    }

    /**
     * @param argument One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
     */
    @JvmName("winntqpvtwrqiipt")
    public suspend
    fun repositoryFilters(argument: suspend RegistryScanningConfigurationRuleRepositoryFilterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RegistryScanningConfigurationRuleRepositoryFilterArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.repositoryFilters = mapped
    }

    /**
     * @param values One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
     */
    @JvmName("xnwsgqewisktxgcw")
    public suspend fun repositoryFilters(
        vararg
        values: RegistryScanningConfigurationRuleRepositoryFilterArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryFilters = mapped
    }

    /**
     * @param value The frequency that scans are performed at for a private registry. Can be `SCAN_ON_PUSH`, `CONTINUOUS_SCAN`, or `MANUAL`.
     */
    @JvmName("oqduckruahwegbuv")
    public suspend fun scanFrequency(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanFrequency = mapped
    }

    internal fun build(): RegistryScanningConfigurationRuleArgs =
        RegistryScanningConfigurationRuleArgs(
            repositoryFilters = repositoryFilters ?: throw PulumiNullFieldException("repositoryFilters"),
            scanFrequency = scanFrequency ?: throw PulumiNullFieldException("scanFrequency"),
        )
}
