@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleRepositoryFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filter
 * @property filterType
 */
public data class RegistryScanningConfigurationRuleRepositoryFilterArgs(
    public val filter: Output<String>,
    public val filterType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleRepositoryFilterArgs> {
    override fun toJava():
        com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleRepositoryFilterArgs =
        com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
            .filter(filter.applyValue({ args0 -> args0 }))
            .filterType(filterType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryScanningConfigurationRuleRepositoryFilterArgs].
 */
@PulumiTagMarker
public class RegistryScanningConfigurationRuleRepositoryFilterArgsBuilder internal constructor() {
    private var filter: Output<String>? = null

    private var filterType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("xvmsweadaojjtsjs")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value
     */
    @JvmName("nnyjtwngppslewaj")
    public suspend fun filterType(`value`: Output<String>) {
        this.filterType = value
    }

    /**
     * @param value
     */
    @JvmName("ounyiakxwxsjkncj")
    public suspend fun filter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value
     */
    @JvmName("hmbbpohtunxbogba")
    public suspend fun filterType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterType = mapped
    }

    internal fun build(): RegistryScanningConfigurationRuleRepositoryFilterArgs =
        RegistryScanningConfigurationRuleRepositoryFilterArgs(
            filter = filter ?: throw PulumiNullFieldException("filter"),
            filterType = filterType ?: throw PulumiNullFieldException("filterType"),
        )
}
