@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property rules The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
 */
public data class ReplicationConfigurationReplicationConfigurationArgs(
    public val rules: Output<List<ReplicationConfigurationReplicationConfigurationRuleArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs =
        com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs.builder()
            .rules(
                rules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReplicationConfigurationReplicationConfigurationArgs].
 */
@PulumiTagMarker
public class ReplicationConfigurationReplicationConfigurationArgsBuilder internal constructor() {
    private var rules: Output<List<ReplicationConfigurationReplicationConfigurationRuleArgs>>? = null

    /**
     * @param value The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
     */
    @JvmName("tygvtjskwtdlvkcu")
    public suspend
    fun rules(`value`: Output<List<ReplicationConfigurationReplicationConfigurationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("wuklkcnfptkmhdjx")
    public suspend fun rules(
        vararg
        values: Output<ReplicationConfigurationReplicationConfigurationRuleArgs>,
    ) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
     */
    @JvmName("lbxpyqbgadukcens")
    public suspend
    fun rules(values: List<Output<ReplicationConfigurationReplicationConfigurationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
     */
    @JvmName("jsywyfpfastjxard")
    public suspend
    fun rules(`value`: List<ReplicationConfigurationReplicationConfigurationRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
     */
    @JvmName("lymrpefuhnfsgmja")
    public suspend
    fun rules(argument: List<suspend ReplicationConfigurationReplicationConfigurationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReplicationConfigurationReplicationConfigurationRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
     */
    @JvmName("dgxhclihojpypbjp")
    public suspend fun rules(
        vararg
        argument: suspend ReplicationConfigurationReplicationConfigurationRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReplicationConfigurationReplicationConfigurationRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
     */
    @JvmName("nwryuxnxkvqvookk")
    public suspend
    fun rules(argument: suspend ReplicationConfigurationReplicationConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ReplicationConfigurationReplicationConfigurationRuleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
     */
    @JvmName("ghcnivakuqjagtbx")
    public suspend fun rules(
        vararg
        values: ReplicationConfigurationReplicationConfigurationRuleArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): ReplicationConfigurationReplicationConfigurationArgs =
        ReplicationConfigurationReplicationConfigurationArgs(
            rules = rules ?: throw PulumiNullFieldException("rules"),
        )
}
