@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property destinations the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
 * @property repositoryFilters filters for a replication rule. See Repository Filter.
 */
public data class ReplicationConfigurationReplicationConfigurationRuleArgs(
    public val destinations:
    Output<List<ReplicationConfigurationReplicationConfigurationRuleDestinationArgs>>,
    public val repositoryFilters:
    Output<List<ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleArgs> {
    override fun toJava():
        com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleArgs =
        com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleArgs.builder()
            .destinations(
                destinations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .repositoryFilters(
                repositoryFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReplicationConfigurationReplicationConfigurationRuleArgs].
 */
@PulumiTagMarker
public class ReplicationConfigurationReplicationConfigurationRuleArgsBuilder internal constructor() {
    private var destinations:
        Output<List<ReplicationConfigurationReplicationConfigurationRuleDestinationArgs>>? = null

    private var repositoryFilters:
        Output<List<ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs>>? = null

    /**
     * @param value the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
     */
    @JvmName("ypimtolljgrmrxir")
    public suspend
    fun destinations(`value`: Output<List<ReplicationConfigurationReplicationConfigurationRuleDestinationArgs>>) {
        this.destinations = value
    }

    @JvmName("liaagewhlfvjxhvv")
    public suspend fun destinations(
        vararg
        values: Output<ReplicationConfigurationReplicationConfigurationRuleDestinationArgs>,
    ) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
     */
    @JvmName("uncbgmyycaudxgbh")
    public suspend
    fun destinations(values: List<Output<ReplicationConfigurationReplicationConfigurationRuleDestinationArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value filters for a replication rule. See Repository Filter.
     */
    @JvmName("umnmevcjjdodacfx")
    public suspend
    fun repositoryFilters(`value`: Output<List<ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs>>) {
        this.repositoryFilters = value
    }

    @JvmName("waqqffseuvuoxdqg")
    public suspend fun repositoryFilters(
        vararg
        values: Output<ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs>,
    ) {
        this.repositoryFilters = Output.all(values.asList())
    }

    /**
     * @param values filters for a replication rule. See Repository Filter.
     */
    @JvmName("wjawvbnjbibqbofo")
    public suspend
    fun repositoryFilters(values: List<Output<ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs>>) {
        this.repositoryFilters = Output.all(values)
    }

    /**
     * @param value the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
     */
    @JvmName("hnswvcgpxbnjfxiv")
    public suspend
    fun destinations(`value`: List<ReplicationConfigurationReplicationConfigurationRuleDestinationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
     */
    @JvmName("rhtesrrihuexvgdk")
    public suspend
    fun destinations(argument: List<suspend ReplicationConfigurationReplicationConfigurationRuleDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReplicationConfigurationReplicationConfigurationRuleDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
     */
    @JvmName("bopncrjnuxunrjex")
    public suspend fun destinations(
        vararg
        argument: suspend ReplicationConfigurationReplicationConfigurationRuleDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReplicationConfigurationReplicationConfigurationRuleDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
     */
    @JvmName("sypexmrnibohxjdf")
    public suspend
    fun destinations(argument: suspend ReplicationConfigurationReplicationConfigurationRuleDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ReplicationConfigurationReplicationConfigurationRuleDestinationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
     */
    @JvmName("krtijqcjilclanfk")
    public suspend fun destinations(
        vararg
        values: ReplicationConfigurationReplicationConfigurationRuleDestinationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value filters for a replication rule. See Repository Filter.
     */
    @JvmName("eedxofleaxrenuww")
    public suspend
    fun repositoryFilters(`value`: List<ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryFilters = mapped
    }

    /**
     * @param argument filters for a replication rule. See Repository Filter.
     */
    @JvmName("djxllnjbrwuxdgyj")
    public suspend
    fun repositoryFilters(argument: List<suspend ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.repositoryFilters = mapped
    }

    /**
     * @param argument filters for a replication rule. See Repository Filter.
     */
    @JvmName("ywrqmkwweoqehnyu")
    public suspend fun repositoryFilters(
        vararg
        argument: suspend ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.repositoryFilters = mapped
    }

    /**
     * @param argument filters for a replication rule. See Repository Filter.
     */
    @JvmName("qgemkbvbgapuicap")
    public suspend
    fun repositoryFilters(argument: suspend ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.repositoryFilters = mapped
    }

    /**
     * @param values filters for a replication rule. See Repository Filter.
     */
    @JvmName("ahyncaxtrmebbyql")
    public suspend fun repositoryFilters(
        vararg
        values: ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryFilters = mapped
    }

    internal fun build(): ReplicationConfigurationReplicationConfigurationRuleArgs =
        ReplicationConfigurationReplicationConfigurationRuleArgs(
            destinations = destinations ?: throw PulumiNullFieldException("destinations"),
            repositoryFilters = repositoryFilters,
        )
}
