@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filter The repository filter details.
 * @property filterType The repository filter type. The only supported value is `PREFIX_MATCH`, which is a repository name prefix specified with the filter parameter.
 */
public data class ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs(
    public val filter: Output<String>,
    public val filterType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs> {
    override fun toJava():
        com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs =
        com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs.builder()
            .filter(filter.applyValue({ args0 -> args0 }))
            .filterType(filterType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs].
 */
@PulumiTagMarker
public class ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsBuilder
internal constructor() {
    private var filter: Output<String>? = null

    private var filterType: Output<String>? = null

    /**
     * @param value The repository filter details.
     */
    @JvmName("fwbgdeeyiaivwcsq")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value The repository filter type. The only supported value is `PREFIX_MATCH`, which is a repository name prefix specified with the filter parameter.
     */
    @JvmName("ahpddedftlqisqvm")
    public suspend fun filterType(`value`: Output<String>) {
        this.filterType = value
    }

    /**
     * @param value The repository filter details.
     */
    @JvmName("qbhqstdqmtqxceik")
    public suspend fun filter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value The repository filter type. The only supported value is `PREFIX_MATCH`, which is a repository name prefix specified with the filter parameter.
     */
    @JvmName("mjsbmxcnhdikwcnm")
    public suspend fun filterType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterType = mapped
    }

    internal fun build(): ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs =
        ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs(
            filter = filter ?: throw PulumiNullFieldException("filter"),
            filterType = filterType ?: throw PulumiNullFieldException("filterType"),
        )
}
