@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.RepositoryImageScanningConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scanOnPush Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).
 */
public data class RepositoryImageScanningConfigurationArgs(
    public val scanOnPush: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.RepositoryImageScanningConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.RepositoryImageScanningConfigurationArgs =
        com.pulumi.aws.ecr.inputs.RepositoryImageScanningConfigurationArgs.builder()
            .scanOnPush(scanOnPush.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryImageScanningConfigurationArgs].
 */
@PulumiTagMarker
public class RepositoryImageScanningConfigurationArgsBuilder internal constructor() {
    private var scanOnPush: Output<Boolean>? = null

    /**
     * @param value Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).
     */
    @JvmName("iqmhijjatvcwekkx")
    public suspend fun scanOnPush(`value`: Output<Boolean>) {
        this.scanOnPush = value
    }

    /**
     * @param value Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).
     */
    @JvmName("mmnofqhhiwaufdfh")
    public suspend fun scanOnPush(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanOnPush = mapped
    }

    internal fun build(): RepositoryImageScanningConfigurationArgs =
        RepositoryImageScanningConfigurationArgs(
            scanOnPush = scanOnPush ?: throw PulumiNullFieldException("scanOnPush"),
        )
}
