@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getImage.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageDigest
 * @property imagePushedAt Date and time, expressed as a unix timestamp, at which the current image was pushed to the repository.
 * @property imageSizeInBytes Size, in bytes, of the image in the repository.
 * @property imageTag
 * @property imageTags List of tags associated with this image.
 * @property mostRecent
 * @property registryId
 * @property repositoryName
 */
public data class GetImageResult(
    public val id: String,
    public val imageDigest: String,
    public val imagePushedAt: Int,
    public val imageSizeInBytes: Int,
    public val imageTag: String? = null,
    public val imageTags: List<String>,
    public val mostRecent: Boolean? = null,
    public val registryId: String,
    public val repositoryName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.GetImageResult): GetImageResult =
            GetImageResult(
                id = javaType.id(),
                imageDigest = javaType.imageDigest(),
                imagePushedAt = javaType.imagePushedAt(),
                imageSizeInBytes = javaType.imageSizeInBytes(),
                imageTag = javaType.imageTag().map({ args0 -> args0 }).orElse(null),
                imageTags = javaType.imageTags().map({ args0 -> args0 }),
                mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
                registryId = javaType.registryId(),
                repositoryName = javaType.repositoryName(),
            )
    }
}
