@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getRepository.
 * @property arn Full ARN of the repository.
 * @property encryptionConfigurations Encryption configuration for the repository. See Encryption Configuration below.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageScanningConfigurations Configuration block that defines image scanning configuration for the repository. See Image Scanning Configuration below.
 * @property imageTagMutability The tag mutability setting for the repository.
 * @property mostRecentImageTags List of image tags associated with the most recently pushed image in the repository.
 * @property name
 * @property registryId
 * @property repositoryUrl URL of the repository (in the form `aws_account_id.dkr.ecr.region.amazonaws.com/repositoryName`).
 * @property tags Map of tags assigned to the resource.
 */
public data class GetRepositoryResult(
    public val arn: String,
    public val encryptionConfigurations: List<GetRepositoryEncryptionConfiguration>,
    public val id: String,
    public val imageScanningConfigurations: List<GetRepositoryImageScanningConfiguration>,
    public val imageTagMutability: String,
    public val mostRecentImageTags: List<String>,
    public val name: String,
    public val registryId: String,
    public val repositoryUrl: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.GetRepositoryResult):
            GetRepositoryResult = GetRepositoryResult(
            arn = javaType.arn(),
            encryptionConfigurations = javaType.encryptionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecr.kotlin.outputs.GetRepositoryEncryptionConfiguration.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            imageScanningConfigurations = javaType.imageScanningConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecr.kotlin.outputs.GetRepositoryImageScanningConfiguration.Companion.toKotlin(args0)
                })
            }),
            imageTagMutability = javaType.imageTagMutability(),
            mostRecentImageTags = javaType.mostRecentImageTags().map({ args0 -> args0 }),
            name = javaType.name(),
            registryId = javaType.registryId(),
            repositoryUrl = javaType.repositoryUrl(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
