@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property destinations the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
 * @property repositoryFilters filters for a replication rule. See Repository Filter.
 */
public data class ReplicationConfigurationReplicationConfigurationRule(
    public val destinations: List<ReplicationConfigurationReplicationConfigurationRuleDestination>,
    public val repositoryFilters:
    List<ReplicationConfigurationReplicationConfigurationRuleRepositoryFilter>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.ReplicationConfigurationReplicationConfigurationRule):
            ReplicationConfigurationReplicationConfigurationRule =
            ReplicationConfigurationReplicationConfigurationRule(
                destinations = javaType.destinations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ecr.kotlin.outputs.ReplicationConfigurationReplicationConfigurationRuleDestination.Companion.toKotlin(args0)
                    })
                }),
                repositoryFilters = javaType.repositoryFilters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ecr.kotlin.outputs.ReplicationConfigurationReplicationConfigurationRuleRepositoryFilter.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
