@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encryptionType The encryption type to use for the repository. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
 * @property kmsKey The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
 */
public data class RepositoryEncryptionConfiguration(
    public val encryptionType: String? = null,
    public val kmsKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.RepositoryEncryptionConfiguration):
            RepositoryEncryptionConfiguration = RepositoryEncryptionConfiguration(
            encryptionType = javaType.encryptionType().map({ args0 -> args0 }).orElse(null),
            kmsKey = javaType.kmsKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
