@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin

import com.pulumi.aws.ecrpublic.EcrpublicFunctions.getAuthorizationTokenPlain
import com.pulumi.aws.ecrpublic.kotlin.outputs.GetAuthorizationTokenResult
import com.pulumi.aws.ecrpublic.kotlin.outputs.GetAuthorizationTokenResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Suppress

public object EcrpublicFunctions {
    /**
     * The Public ECR Authorization Token data source allows the authorization token, token expiration date, user name, and password to be retrieved for a Public ECR repository.
     * > **NOTE:** This data source can only be used in the `us-east-1` region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecrpublic.EcrpublicFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var token = EcrpublicFunctions.getAuthorizationToken();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecrpublic.EcrpublicFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var token = EcrpublicFunctions.getAuthorizationToken();
     *     }
     * }
     * ```
     * @param argument The Public ECR Authorization Token data source allows the authorization token, token expiration date, user name, and password to be retrieved for a Public ECR repository.
     * > **NOTE:** This data source can only be used in the `us-east-1` region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecrpublic.EcrpublicFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var token = EcrpublicFunctions.getAuthorizationToken();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecrpublic.EcrpublicFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var token = EcrpublicFunctions.getAuthorizationToken();
     *     }
     * }
     * ```
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend fun getAuthorizationToken(): GetAuthorizationTokenResult =
        toKotlin(getAuthorizationTokenPlain().await())
}
