@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin

import com.pulumi.aws.ecrpublic.kotlin.outputs.RepositoryCatalogData
import com.pulumi.aws.ecrpublic.kotlin.outputs.RepositoryCatalogData.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Repository].
 */
@PulumiTagMarker
public class RepositoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepositoryArgs = RepositoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepositoryArgsBuilder.() -> Unit) {
        val builder = RepositoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Repository {
        val builtJavaResource = com.pulumi.aws.ecrpublic.Repository(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Repository(builtJavaResource)
    }
}

/**
 * Provides a Public Elastic Container Registry Repository.
 * > **NOTE:** This resource can only be used in the `us-east-1` region.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.ecrpublic.Repository;
 * import com.pulumi.aws.ecrpublic.RepositoryArgs;
 * import com.pulumi.aws.ecrpublic.inputs.RepositoryCatalogDataArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var usEast1 = new Provider("usEast1", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var foo = new Repository("foo", RepositoryArgs.builder()
 *             .repositoryName("bar")
 *             .catalogData(RepositoryCatalogDataArgs.builder()
 *                 .aboutText("About Text")
 *                 .architectures("ARM")
 *                 .description("Description")
 *                 .logoImageBlob(Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get(image.png()))))
 *                 .operatingSystems("Linux")
 *                 .usageText("Usage Text")
 *                 .build())
 *             .tags(Map.of("env", "production"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us_east_1())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Public Repositories using the `repository_name`. For example:
 * ```sh
 *  $ pulumi import aws:ecrpublic/repository:Repository example example
 * ```
 *
 */
public class Repository internal constructor(
    override val javaResource: com.pulumi.aws.ecrpublic.Repository,
) : KotlinCustomResource(javaResource, RepositoryMapper) {
    /**
     * Full ARN of the repository.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Catalog data configuration for the repository. See below for schema.
     */
    public val catalogData: Output<RepositoryCatalogData>?
        get() = javaResource.catalogData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The registry ID where the repository was created.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })

    /**
     * Name of the repository.
     */
    public val repositoryName: Output<String>
        get() = javaResource.repositoryName().applyValue({ args0 -> args0 })

    /**
     * The URI of the repository.
     */
    public val repositoryUri: Output<String>
        get() = javaResource.repositoryUri().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RepositoryMapper : ResourceMapper<Repository> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecrpublic.Repository::class == javaResource::class

    override fun map(javaResource: Resource): Repository = Repository(
        javaResource as
            com.pulumi.aws.ecrpublic.Repository,
    )
}

/**
 * @see [Repository].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Repository].
 */
public suspend fun repository(name: String, block: suspend RepositoryResourceBuilder.() -> Unit):
    Repository {
    val builder = RepositoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Repository].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repository(name: String): Repository {
    val builder = RepositoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
