@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin

import com.pulumi.aws.ecrpublic.RepositoryArgs.builder
import com.pulumi.aws.ecrpublic.kotlin.inputs.RepositoryCatalogDataArgs
import com.pulumi.aws.ecrpublic.kotlin.inputs.RepositoryCatalogDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Public Elastic Container Registry Repository.
 * > **NOTE:** This resource can only be used in the `us-east-1` region.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.ecrpublic.Repository;
 * import com.pulumi.aws.ecrpublic.RepositoryArgs;
 * import com.pulumi.aws.ecrpublic.inputs.RepositoryCatalogDataArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var usEast1 = new Provider("usEast1", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var foo = new Repository("foo", RepositoryArgs.builder()
 *             .repositoryName("bar")
 *             .catalogData(RepositoryCatalogDataArgs.builder()
 *                 .aboutText("About Text")
 *                 .architectures("ARM")
 *                 .description("Description")
 *                 .logoImageBlob(Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get(image.png()))))
 *                 .operatingSystems("Linux")
 *                 .usageText("Usage Text")
 *                 .build())
 *             .tags(Map.of("env", "production"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us_east_1())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Public Repositories using the `repository_name`. For example:
 * ```sh
 *  $ pulumi import aws:ecrpublic/repository:Repository example example
 * ```
 * @property catalogData Catalog data configuration for the repository. See below for schema.
 * @property forceDestroy
 * @property repositoryName Name of the repository.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RepositoryArgs(
    public val catalogData: Output<RepositoryCatalogDataArgs>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val repositoryName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecrpublic.RepositoryArgs> {
    override fun toJava(): com.pulumi.aws.ecrpublic.RepositoryArgs =
        com.pulumi.aws.ecrpublic.RepositoryArgs.builder()
            .catalogData(catalogData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RepositoryArgs].
 */
@PulumiTagMarker
public class RepositoryArgsBuilder internal constructor() {
    private var catalogData: Output<RepositoryCatalogDataArgs>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var repositoryName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Catalog data configuration for the repository. See below for schema.
     */
    @JvmName("divhogvheycafdxn")
    public suspend fun catalogData(`value`: Output<RepositoryCatalogDataArgs>) {
        this.catalogData = value
    }

    /**
     * @param value
     */
    @JvmName("alkabognltlshqor")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value Name of the repository.
     */
    @JvmName("yyukveroychvujbh")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gkqunecfagaegviv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Catalog data configuration for the repository. See below for schema.
     */
    @JvmName("tjpkapbrwnuwolgc")
    public suspend fun catalogData(`value`: RepositoryCatalogDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogData = mapped
    }

    /**
     * @param argument Catalog data configuration for the repository. See below for schema.
     */
    @JvmName("behxawuexadrjliv")
    public suspend fun catalogData(argument: suspend RepositoryCatalogDataArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryCatalogDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.catalogData = mapped
    }

    /**
     * @param value
     */
    @JvmName("dptfrxoqntxowggr")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value Name of the repository.
     */
    @JvmName("ivlgwbugkodgskxo")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nwlutcvuquybsnfl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("takbvxkqfwpupthn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RepositoryArgs = RepositoryArgs(
        catalogData = catalogData,
        forceDestroy = forceDestroy,
        repositoryName = repositoryName,
        tags = tags,
    )
}
