@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RepositoryPolicy].
 */
@PulumiTagMarker
public class RepositoryPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepositoryPolicyArgs = RepositoryPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepositoryPolicyArgsBuilder.() -> Unit) {
        val builder = RepositoryPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RepositoryPolicy {
        val builtJavaResource = com.pulumi.aws.ecrpublic.RepositoryPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RepositoryPolicy(builtJavaResource)
    }
}

/**
 * Provides an Elastic Container Registry Public Repository Policy.
 * Note that currently only one policy may be applied to a repository.
 * > **NOTE:** This resource can only be used in the `us-east-1` region.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecrpublic.Repository;
 * import com.pulumi.aws.ecrpublic.RepositoryArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ecrpublic.RepositoryPolicy;
 * import com.pulumi.aws.ecrpublic.RepositoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRepository = new Repository("exampleRepository", RepositoryArgs.builder()
 *             .repositoryName("example")
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("new policy")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions(
 *                     "ecr:GetDownloadUrlForLayer",
 *                     "ecr:BatchGetImage",
 *                     "ecr:BatchCheckLayerAvailability",
 *                     "ecr:PutImage",
 *                     "ecr:InitiateLayerUpload",
 *                     "ecr:UploadLayerPart",
 *                     "ecr:CompleteLayerUpload",
 *                     "ecr:DescribeRepositories",
 *                     "ecr:GetRepositoryPolicy",
 *                     "ecr:ListImages",
 *                     "ecr:DeleteRepository",
 *                     "ecr:BatchDeleteImage",
 *                     "ecr:SetRepositoryPolicy",
 *                     "ecr:DeleteRepositoryPolicy")
 *                 .build())
 *             .build());
 *         var exampleRepositoryPolicy = new RepositoryPolicy("exampleRepositoryPolicy", RepositoryPolicyArgs.builder()
 *             .repositoryName(exampleRepository.repositoryName())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Public Repository Policy using the repository name. For example:
 * ```sh
 *  $ pulumi import aws:ecrpublic/repositoryPolicy:RepositoryPolicy example example
 * ```
 *
 */
public class RepositoryPolicy internal constructor(
    override val javaResource: com.pulumi.aws.ecrpublic.RepositoryPolicy,
) : KotlinCustomResource(javaResource, RepositoryPolicyMapper) {
    /**
     * The policy document. This is a JSON formatted string.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The registry ID where the repository was created.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })

    /**
     * Name of the repository to apply the policy.
     */
    public val repositoryName: Output<String>
        get() = javaResource.repositoryName().applyValue({ args0 -> args0 })
}

public object RepositoryPolicyMapper : ResourceMapper<RepositoryPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecrpublic.RepositoryPolicy::class == javaResource::class

    override fun map(javaResource: Resource): RepositoryPolicy = RepositoryPolicy(
        javaResource as
            com.pulumi.aws.ecrpublic.RepositoryPolicy,
    )
}

/**
 * @see [RepositoryPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RepositoryPolicy].
 */
public suspend fun repositoryPolicy(
    name: String,
    block: suspend RepositoryPolicyResourceBuilder.() -> Unit,
): RepositoryPolicy {
    val builder = RepositoryPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RepositoryPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repositoryPolicy(name: String): RepositoryPolicy {
    val builder = RepositoryPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
