@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin

import com.pulumi.aws.ecrpublic.RepositoryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Container Registry Public Repository Policy.
 * Note that currently only one policy may be applied to a repository.
 * > **NOTE:** This resource can only be used in the `us-east-1` region.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecrpublic.Repository;
 * import com.pulumi.aws.ecrpublic.RepositoryArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ecrpublic.RepositoryPolicy;
 * import com.pulumi.aws.ecrpublic.RepositoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRepository = new Repository("exampleRepository", RepositoryArgs.builder()
 *             .repositoryName("example")
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("new policy")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions(
 *                     "ecr:GetDownloadUrlForLayer",
 *                     "ecr:BatchGetImage",
 *                     "ecr:BatchCheckLayerAvailability",
 *                     "ecr:PutImage",
 *                     "ecr:InitiateLayerUpload",
 *                     "ecr:UploadLayerPart",
 *                     "ecr:CompleteLayerUpload",
 *                     "ecr:DescribeRepositories",
 *                     "ecr:GetRepositoryPolicy",
 *                     "ecr:ListImages",
 *                     "ecr:DeleteRepository",
 *                     "ecr:BatchDeleteImage",
 *                     "ecr:SetRepositoryPolicy",
 *                     "ecr:DeleteRepositoryPolicy")
 *                 .build())
 *             .build());
 *         var exampleRepositoryPolicy = new RepositoryPolicy("exampleRepositoryPolicy", RepositoryPolicyArgs.builder()
 *             .repositoryName(exampleRepository.repositoryName())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Public Repository Policy using the repository name. For example:
 * ```sh
 *  $ pulumi import aws:ecrpublic/repositoryPolicy:RepositoryPolicy example example
 * ```
 * @property policy The policy document. This is a JSON formatted string.
 * @property repositoryName Name of the repository to apply the policy.
 */
public data class RepositoryPolicyArgs(
    public val policy: Output<String>? = null,
    public val repositoryName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecrpublic.RepositoryPolicyArgs> {
    override fun toJava(): com.pulumi.aws.ecrpublic.RepositoryPolicyArgs =
        com.pulumi.aws.ecrpublic.RepositoryPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryPolicyArgs].
 */
@PulumiTagMarker
public class RepositoryPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var repositoryName: Output<String>? = null

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("bldbxwpyhgdmfqcv")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Name of the repository to apply the policy.
     */
    @JvmName("jaawssylldensanr")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("axrtelqjfffdmusb")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Name of the repository to apply the policy.
     */
    @JvmName("kqvxrqmyaxgphikc")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    internal fun build(): RepositoryPolicyArgs = RepositoryPolicyArgs(
        policy = policy,
        repositoryName = repositoryName,
    )
}
