@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin.inputs

import com.pulumi.aws.ecrpublic.inputs.RepositoryCatalogDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property aboutText A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
 * @property architectures The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
 * @property description A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
 * @property logoImageBlob The base64-encoded repository logo payload. (Only visible for verified accounts) Note that drift detection is disabled for this attribute.
 * @property operatingSystems The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
 * @property usageText Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
 */
public data class RepositoryCatalogDataArgs(
    public val aboutText: Output<String>? = null,
    public val architectures: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val logoImageBlob: Output<String>? = null,
    public val operatingSystems: Output<List<String>>? = null,
    public val usageText: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecrpublic.inputs.RepositoryCatalogDataArgs> {
    override fun toJava(): com.pulumi.aws.ecrpublic.inputs.RepositoryCatalogDataArgs =
        com.pulumi.aws.ecrpublic.inputs.RepositoryCatalogDataArgs.builder()
            .aboutText(aboutText?.applyValue({ args0 -> args0 }))
            .architectures(architectures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .logoImageBlob(logoImageBlob?.applyValue({ args0 -> args0 }))
            .operatingSystems(operatingSystems?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .usageText(usageText?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryCatalogDataArgs].
 */
@PulumiTagMarker
public class RepositoryCatalogDataArgsBuilder internal constructor() {
    private var aboutText: Output<String>? = null

    private var architectures: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var logoImageBlob: Output<String>? = null

    private var operatingSystems: Output<List<String>>? = null

    private var usageText: Output<String>? = null

    /**
     * @param value A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
     */
    @JvmName("ggrhpufoitiwwjuj")
    public suspend fun aboutText(`value`: Output<String>) {
        this.aboutText = value
    }

    /**
     * @param value The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
     */
    @JvmName("vryulvhjbgehrlvy")
    public suspend fun architectures(`value`: Output<List<String>>) {
        this.architectures = value
    }

    @JvmName("fabhqeyqquykitph")
    public suspend fun architectures(vararg values: Output<String>) {
        this.architectures = Output.all(values.asList())
    }

    /**
     * @param values The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
     */
    @JvmName("dpioppusybbafdxt")
    public suspend fun architectures(values: List<Output<String>>) {
        this.architectures = Output.all(values)
    }

    /**
     * @param value A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
     */
    @JvmName("gvjqsfcnryxvmtrb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The base64-encoded repository logo payload. (Only visible for verified accounts) Note that drift detection is disabled for this attribute.
     */
    @JvmName("fkkbmpsbjqfrxcie")
    public suspend fun logoImageBlob(`value`: Output<String>) {
        this.logoImageBlob = value
    }

    /**
     * @param value The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
     */
    @JvmName("clhqwiqrranuwfgy")
    public suspend fun operatingSystems(`value`: Output<List<String>>) {
        this.operatingSystems = value
    }

    @JvmName("aifgcjibnfpnqasu")
    public suspend fun operatingSystems(vararg values: Output<String>) {
        this.operatingSystems = Output.all(values.asList())
    }

    /**
     * @param values The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
     */
    @JvmName("dfqplyjgaxcqvsoo")
    public suspend fun operatingSystems(values: List<Output<String>>) {
        this.operatingSystems = Output.all(values)
    }

    /**
     * @param value Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
     */
    @JvmName("oybpwhjvxtgualmf")
    public suspend fun usageText(`value`: Output<String>) {
        this.usageText = value
    }

    /**
     * @param value A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
     */
    @JvmName("jfrneysgkxstffrl")
    public suspend fun aboutText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aboutText = mapped
    }

    /**
     * @param value The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
     */
    @JvmName("mjarpjunmfaijgxy")
    public suspend fun architectures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architectures = mapped
    }

    /**
     * @param values The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
     */
    @JvmName("bkekbfbkmolejjsi")
    public suspend fun architectures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architectures = mapped
    }

    /**
     * @param value A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
     */
    @JvmName("qbnqlgjgymswkuca")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The base64-encoded repository logo payload. (Only visible for verified accounts) Note that drift detection is disabled for this attribute.
     */
    @JvmName("anqnvuidojgjymdy")
    public suspend fun logoImageBlob(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logoImageBlob = mapped
    }

    /**
     * @param value The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
     */
    @JvmName("dmegkubjmsdsijkm")
    public suspend fun operatingSystems(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingSystems = mapped
    }

    /**
     * @param values The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
     */
    @JvmName("ovulflpjbrcgpgfo")
    public suspend fun operatingSystems(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatingSystems = mapped
    }

    /**
     * @param value Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
     */
    @JvmName("pwcmqlhdjjfwhmbh")
    public suspend fun usageText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageText = mapped
    }

    internal fun build(): RepositoryCatalogDataArgs = RepositoryCatalogDataArgs(
        aboutText = aboutText,
        architectures = architectures,
        description = description,
        logoImageBlob = logoImageBlob,
        operatingSystems = operatingSystems,
        usageText = usageText,
    )
}
