@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAuthorizationToken.
 * @property authorizationToken Temporary IAM authentication credentials to access the ECR repository encoded in base64 in the form of `user_name:password`.
 * @property expiresAt Time in UTC RFC3339 format when the authorization token expires.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property password Password decoded from the authorization token.
 * @property userName User name decoded from the authorization token.
 */
public data class GetAuthorizationTokenResult(
    public val authorizationToken: String,
    public val expiresAt: String,
    public val id: String,
    public val password: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecrpublic.outputs.GetAuthorizationTokenResult):
            GetAuthorizationTokenResult = GetAuthorizationTokenResult(
            authorizationToken = javaType.authorizationToken(),
            expiresAt = javaType.expiresAt(),
            id = javaType.id(),
            password = javaType.password(),
            userName = javaType.userName(),
        )
    }
}
