@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountSettingDefault].
 */
@PulumiTagMarker
public class AccountSettingDefaultResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountSettingDefaultArgs = AccountSettingDefaultArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountSettingDefaultArgsBuilder.() -> Unit) {
        val builder = AccountSettingDefaultArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccountSettingDefault {
        val builtJavaResource = com.pulumi.aws.ecs.AccountSettingDefault(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountSettingDefault(builtJavaResource)
    }
}

/**
 * Provides an ECS default account setting for a specific ECS Resource name within a specific region. More information can be found on the [ECS Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html).
 * > **NOTE:** The AWS API does not delete this resource. When you run `destroy`, the provider will attempt to disable the setting.
 * > **NOTE:** Your AWS account may not support disabling `containerInstanceLongArnFormat`, `serviceLongArnFormat`, and `taskLongArnFormat`. If your account does not support disabling these, "destroying" this resource will not disable the setting nor cause a provider error. However, the AWS Provider will log an AWS error: `InvalidParameterException: You can no longer disable Long Arn settings`.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.AccountSettingDefault;
 * import com.pulumi.aws.ecs.AccountSettingDefaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AccountSettingDefault("test", AccountSettingDefaultArgs.builder()
 *             .value("enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECS Account Setting defaults using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:ecs/accountSettingDefault:AccountSettingDefault example taskLongArnFormat
 * ```
 *
 */
public class AccountSettingDefault internal constructor(
    override val javaResource: com.pulumi.aws.ecs.AccountSettingDefault,
) : KotlinCustomResource(javaResource, AccountSettingDefaultMapper) {
    /**
     * Name of the account setting to set. Valid values are `serviceLongArnFormat`, `taskLongArnFormat`, `containerInstanceLongArnFormat`, `awsvpcTrunking` and `containerInsights`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val principalArn: Output<String>
        get() = javaResource.principalArn().applyValue({ args0 -> args0 })

    /**
     * State of the setting. Valid values are `enabled` and `disabled`.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object AccountSettingDefaultMapper : ResourceMapper<AccountSettingDefault> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecs.AccountSettingDefault::class == javaResource::class

    override fun map(javaResource: Resource): AccountSettingDefault =
        AccountSettingDefault(javaResource as com.pulumi.aws.ecs.AccountSettingDefault)
}

/**
 * @see [AccountSettingDefault].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountSettingDefault].
 */
public suspend fun accountSettingDefault(
    name: String,
    block: suspend AccountSettingDefaultResourceBuilder.() -> Unit,
): AccountSettingDefault {
    val builder = AccountSettingDefaultResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountSettingDefault].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountSettingDefault(name: String): AccountSettingDefault {
    val builder = AccountSettingDefaultResourceBuilder()
    builder.name(name)
    return builder.build()
}
