@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.CapacityProviderArgs.builder
import com.pulumi.aws.ecs.kotlin.inputs.CapacityProviderAutoScalingGroupProviderArgs
import com.pulumi.aws.ecs.kotlin.inputs.CapacityProviderAutoScalingGroupProviderArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ECS cluster capacity provider. More information can be found on the [ECS Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-capacity-providers.html).
 * > **NOTE:** Associating an ECS Capacity Provider to an Auto Scaling Group will automatically add the `AmazonECSManaged` tag to the Auto Scaling Group. This tag should be included in the `aws.autoscaling.Group` resource configuration to prevent the provider from removing it in subsequent executions as well as ensuring the `AmazonECSManaged` tag is propagated to all EC2 Instances in the Auto Scaling Group if `min_size` is above 0 on creation. Any EC2 Instances in the Auto Scaling Group without this tag must be manually be updated, otherwise they may cause unexpected scaling behavior and metrics.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import com.pulumi.aws.ecs.CapacityProvider;
 * import com.pulumi.aws.ecs.CapacityProviderArgs;
 * import com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderArgs;
 * import com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderManagedScalingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testGroup = new Group("testGroup", GroupArgs.builder()
 *             .tags(GroupTagArgs.builder()
 *                 .key("AmazonECSManaged")
 *                 .value(true)
 *                 .propagateAtLaunch(true)
 *                 .build())
 *             .build());
 *         var testCapacityProvider = new CapacityProvider("testCapacityProvider", CapacityProviderArgs.builder()
 *             .autoScalingGroupProvider(CapacityProviderAutoScalingGroupProviderArgs.builder()
 *                 .autoScalingGroupArn(testGroup.arn())
 *                 .managedTerminationProtection("ENABLED")
 *                 .managedScaling(CapacityProviderAutoScalingGroupProviderManagedScalingArgs.builder()
 *                     .maximumScalingStepSize(1000)
 *                     .minimumScalingStepSize(1)
 *                     .status("ENABLED")
 *                     .targetCapacity(10)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECS Capacity Providers using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:ecs/capacityProvider:CapacityProvider example example
 * ```
 * @property autoScalingGroupProvider Configuration block for the provider for the ECS auto scaling group. Detailed below.
 * @property name Name of the capacity provider.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CapacityProviderArgs(
    public val autoScalingGroupProvider: Output<CapacityProviderAutoScalingGroupProviderArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.CapacityProviderArgs> {
    override fun toJava(): com.pulumi.aws.ecs.CapacityProviderArgs =
        com.pulumi.aws.ecs.CapacityProviderArgs.builder()
            .autoScalingGroupProvider(
                autoScalingGroupProvider?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CapacityProviderArgs].
 */
@PulumiTagMarker
public class CapacityProviderArgsBuilder internal constructor() {
    private var autoScalingGroupProvider: Output<CapacityProviderAutoScalingGroupProviderArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block for the provider for the ECS auto scaling group. Detailed below.
     */
    @JvmName("dqtkdgyihbwxgter")
    public suspend
    fun autoScalingGroupProvider(`value`: Output<CapacityProviderAutoScalingGroupProviderArgs>) {
        this.autoScalingGroupProvider = value
    }

    /**
     * @param value Name of the capacity provider.
     */
    @JvmName("prlshciiaalinysp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("foglfojhufjqlpox")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the provider for the ECS auto scaling group. Detailed below.
     */
    @JvmName("rbmgobphelfuttag")
    public suspend
    fun autoScalingGroupProvider(`value`: CapacityProviderAutoScalingGroupProviderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingGroupProvider = mapped
    }

    /**
     * @param argument Configuration block for the provider for the ECS auto scaling group. Detailed below.
     */
    @JvmName("ybiqolvukevieifn")
    public suspend
    fun autoScalingGroupProvider(argument: suspend CapacityProviderAutoScalingGroupProviderArgsBuilder.() -> Unit) {
        val toBeMapped = CapacityProviderAutoScalingGroupProviderArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoScalingGroupProvider = mapped
    }

    /**
     * @param value Name of the capacity provider.
     */
    @JvmName("irodhrlrtdqfmugw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vrffdreymiwanohd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("shlxkowfxwaruslw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CapacityProviderArgs = CapacityProviderArgs(
        autoScalingGroupProvider = autoScalingGroupProvider,
        name = name,
        tags = tags,
    )
}
