@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.kotlin.outputs.ClusterConfiguration
import com.pulumi.aws.ecs.kotlin.outputs.ClusterServiceConnectDefaults
import com.pulumi.aws.ecs.kotlin.outputs.ClusterSetting
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ecs.kotlin.outputs.ClusterConfiguration.Companion.toKotlin as clusterConfigurationToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ClusterServiceConnectDefaults.Companion.toKotlin as clusterServiceConnectDefaultsToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ClusterSetting.Companion.toKotlin as clusterSettingToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.aws.ecs.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Provides an ECS cluster.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Cluster("foo", ClusterArgs.builder()
 *             .settings(ClusterSettingArgs.builder()
 *                 .name("containerInsights")
 *                 .value("enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example with Log Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var test = new Cluster("test", ClusterArgs.builder()
 *             .configuration(ClusterConfigurationArgs.builder()
 *                 .executeCommandConfiguration(ClusterConfigurationExecuteCommandConfigurationArgs.builder()
 *                     .kmsKeyId(exampleKey.arn())
 *                     .logging("OVERRIDE")
 *                     .logConfiguration(ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs.builder()
 *                         .cloudWatchEncryptionEnabled(true)
 *                         .cloudWatchLogGroupName(exampleLogGroup.name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECS clusters using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:ecs/cluster:Cluster stateless stateless-app
 * ```
 *
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.aws.ecs.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * ARN that identifies the cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The execute command configuration for the cluster. Detailed below.
     */
    public val configuration: Output<ClusterConfiguration>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configures a default Service Connect namespace. Detailed below.
     */
    public val serviceConnectDefaults: Output<ClusterServiceConnectDefaults>?
        get() = javaResource.serviceConnectDefaults().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterServiceConnectDefaultsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     */
    public val settings: Output<List<ClusterSetting>>
        get() = javaResource.settings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterSettingToKotlin(args0)
                })
            })
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecs.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.aws.ecs.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit):
    Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
