@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.ClusterArgs.builder
import com.pulumi.aws.ecs.kotlin.inputs.ClusterConfigurationArgs
import com.pulumi.aws.ecs.kotlin.inputs.ClusterConfigurationArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ClusterServiceConnectDefaultsArgs
import com.pulumi.aws.ecs.kotlin.inputs.ClusterServiceConnectDefaultsArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ClusterSettingArgs
import com.pulumi.aws.ecs.kotlin.inputs.ClusterSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ECS cluster.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Cluster("foo", ClusterArgs.builder()
 *             .settings(ClusterSettingArgs.builder()
 *                 .name("containerInsights")
 *                 .value("enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example with Log Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var test = new Cluster("test", ClusterArgs.builder()
 *             .configuration(ClusterConfigurationArgs.builder()
 *                 .executeCommandConfiguration(ClusterConfigurationExecuteCommandConfigurationArgs.builder()
 *                     .kmsKeyId(exampleKey.arn())
 *                     .logging("OVERRIDE")
 *                     .logConfiguration(ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs.builder()
 *                         .cloudWatchEncryptionEnabled(true)
 *                         .cloudWatchLogGroupName(exampleLogGroup.name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECS clusters using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:ecs/cluster:Cluster stateless stateless-app
 * ```
 * @property configuration The execute command configuration for the cluster. Detailed below.
 * @property name Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
 * @property serviceConnectDefaults Configures a default Service Connect namespace. Detailed below.
 * @property settings Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterArgs(
    public val configuration: Output<ClusterConfigurationArgs>? = null,
    public val name: Output<String>? = null,
    public val serviceConnectDefaults: Output<ClusterServiceConnectDefaultsArgs>? = null,
    public val settings: Output<List<ClusterSettingArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.ecs.ClusterArgs = com.pulumi.aws.ecs.ClusterArgs.builder()
        .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .name(name?.applyValue({ args0 -> args0 }))
        .serviceConnectDefaults(
            serviceConnectDefaults?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .settings(
            settings?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var configuration: Output<ClusterConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var serviceConnectDefaults: Output<ClusterServiceConnectDefaultsArgs>? = null

    private var settings: Output<List<ClusterSettingArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The execute command configuration for the cluster. Detailed below.
     */
    @JvmName("ptcufdhrfjrponay")
    public suspend fun configuration(`value`: Output<ClusterConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
     */
    @JvmName("afjevwbrxrftlakr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configures a default Service Connect namespace. Detailed below.
     */
    @JvmName("dswvqnrcikocqnfk")
    public suspend fun serviceConnectDefaults(`value`: Output<ClusterServiceConnectDefaultsArgs>) {
        this.serviceConnectDefaults = value
    }

    /**
     * @param value Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     */
    @JvmName("yoqcdxjqffwqmauq")
    public suspend fun settings(`value`: Output<List<ClusterSettingArgs>>) {
        this.settings = value
    }

    @JvmName("tdukruarifkgfaut")
    public suspend fun settings(vararg values: Output<ClusterSettingArgs>) {
        this.settings = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     */
    @JvmName("hvlbwgjsgxqmofoa")
    public suspend fun settings(values: List<Output<ClusterSettingArgs>>) {
        this.settings = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("luciytrubwhblary")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The execute command configuration for the cluster. Detailed below.
     */
    @JvmName("qsmnnphwtfgdhccp")
    public suspend fun configuration(`value`: ClusterConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument The execute command configuration for the cluster. Detailed below.
     */
    @JvmName("qjbfhlxddtufctsu")
    public suspend fun configuration(argument: suspend ClusterConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
     */
    @JvmName("eymqqqgcxrisiqin")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configures a default Service Connect namespace. Detailed below.
     */
    @JvmName("gmamouenalqdpcok")
    public suspend fun serviceConnectDefaults(`value`: ClusterServiceConnectDefaultsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceConnectDefaults = mapped
    }

    /**
     * @param argument Configures a default Service Connect namespace. Detailed below.
     */
    @JvmName("etensdudaqhmiudv")
    public suspend
    fun serviceConnectDefaults(argument: suspend ClusterServiceConnectDefaultsArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterServiceConnectDefaultsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceConnectDefaults = mapped
    }

    /**
     * @param value Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     */
    @JvmName("kpxojmyyhsrlqvvc")
    public suspend fun settings(`value`: List<ClusterSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     */
    @JvmName("etxfkjsypsfeuswc")
    public suspend fun settings(argument: List<suspend ClusterSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     */
    @JvmName("njxosjikfbnwtsdq")
    public suspend fun settings(vararg argument: suspend ClusterSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     */
    @JvmName("nckohncbgyouomll")
    public suspend fun settings(argument: suspend ClusterSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param values Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     */
    @JvmName("wjbnhakdiewvurwo")
    public suspend fun settings(vararg values: ClusterSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tsmuoqsgrijvlcpp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lmhkreytrmvpjrcs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        configuration = configuration,
        name = name,
        serviceConnectDefaults = serviceConnectDefaults,
        settings = settings,
        tags = tags,
    )
}
