@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.EcsFunctions.getClusterPlain
import com.pulumi.aws.ecs.EcsFunctions.getContainerDefinitionPlain
import com.pulumi.aws.ecs.EcsFunctions.getServicePlain
import com.pulumi.aws.ecs.EcsFunctions.getTaskDefinitionPlain
import com.pulumi.aws.ecs.EcsFunctions.getTaskExecutionPlain
import com.pulumi.aws.ecs.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.GetContainerDefinitionPlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetContainerDefinitionPlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.GetServicePlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskDefinitionPlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskDefinitionPlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionCapacityProviderStrategy
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionNetworkConfiguration
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionOverrides
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionPlacementConstraint
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionPlacementStrategy
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionPlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionPlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.outputs.GetClusterResult
import com.pulumi.aws.ecs.kotlin.outputs.GetContainerDefinitionResult
import com.pulumi.aws.ecs.kotlin.outputs.GetServiceResult
import com.pulumi.aws.ecs.kotlin.outputs.GetTaskDefinitionResult
import com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ecs.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.GetContainerDefinitionResult.Companion.toKotlin as getContainerDefinitionResultToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.GetTaskDefinitionResult.Companion.toKotlin as getTaskDefinitionResultToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionResult.Companion.toKotlin as getTaskExecutionResultToKotlin

public object EcsFunctions {
    /**
     * The ECS Cluster data source allows access to details of a specific
     * cluster within an AWS ECS service.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecs.EcsFunctions;
     * import com.pulumi.aws.ecs.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ecs-mongo = EcsFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterName("ecs-mongo-production")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName Name of the ECS Cluster
     * @param tags Key-value map of resource tags
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(clusterName: String, tags: Map<String, String>? = null):
        GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * The ECS container definition data source allows access to details of
     * a specific container within an AWS ECS service.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecs.EcsFunctions;
     * import com.pulumi.aws.ecs.inputs.GetContainerDefinitionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ecs-mongo = EcsFunctions.getContainerDefinition(GetContainerDefinitionArgs.builder()
     *             .taskDefinition(aws_ecs_task_definition.mongo().id())
     *             .containerName("mongodb")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getContainerDefinition.
     * @return A collection of values returned by getContainerDefinition.
     */
    public suspend fun getContainerDefinition(argument: GetContainerDefinitionPlainArgs):
        GetContainerDefinitionResult =
        getContainerDefinitionResultToKotlin(getContainerDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getContainerDefinition].
     * @param containerName Name of the container definition
     * @param taskDefinition ARN of the task definition which contains the container
     * @return A collection of values returned by getContainerDefinition.
     */
    public suspend fun getContainerDefinition(containerName: String, taskDefinition: String):
        GetContainerDefinitionResult {
        val argument = GetContainerDefinitionPlainArgs(
            containerName = containerName,
            taskDefinition = taskDefinition,
        )
        return getContainerDefinitionResultToKotlin(getContainerDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetContainerDefinitionPlainArgs].
     * @return A collection of values returned by getContainerDefinition.
     */
    public suspend
    fun getContainerDefinition(argument: suspend GetContainerDefinitionPlainArgsBuilder.() -> Unit):
        GetContainerDefinitionResult {
        val builder = GetContainerDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerDefinitionResultToKotlin(getContainerDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * The ECS Service data source allows access to details of a specific
     * Service within a AWS ECS Cluster.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecs.EcsFunctions;
     * import com.pulumi.aws.ecs.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getService(GetServiceArgs.builder()
     *             .serviceName("example")
     *             .clusterArn(data.aws_ecs_cluster().example().arn())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param clusterArn ARN of the ECS Cluster
     * @param serviceName Name of the ECS Service
     * @param tags Resource tags.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(
        clusterArn: String,
        serviceName: String,
        tags: Map<String, String>? = null,
    ): GetServiceResult {
        val argument = GetServicePlainArgs(
            clusterArn = clusterArn,
            serviceName = serviceName,
            tags = tags,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit):
        GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * The ECS task definition data source allows access to details of
     * a specific AWS ECS task definition.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecs.EcsFunctions;
     * import com.pulumi.aws.ecs.inputs.GetTaskDefinitionArgs;
     * import com.pulumi.aws.ecs.Cluster;
     * import com.pulumi.aws.ecs.TaskDefinition;
     * import com.pulumi.aws.ecs.TaskDefinitionArgs;
     * import com.pulumi.aws.ecs.Service;
     * import com.pulumi.aws.ecs.ServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var mongoTaskDefinition = EcsFunctions.getTaskDefinition(GetTaskDefinitionArgs.builder()
     *             .taskDefinition(mongoEcs / taskDefinitionTaskDefinition.family())
     *             .build());
     *         var foo = new Cluster("foo");
     *         var mongoEcs_taskDefinitionTaskDefinition = new TaskDefinition("mongoEcs/taskDefinitionTaskDefinition", TaskDefinitionArgs.builder()
     *             .family("mongodb")
     *             .containerDefinitions("""
     * [
     *   {
     *     "cpu": 128,
     *     "environment": [{
     *       "name": "SECRET",
     *       "value": "KEY"
     *     }],
     *     "essential": true,
     *     "image": "mongo:latest",
     *     "memory": 128,
     *     "memoryReservation": 64,
     *     "name": "mongodb"
     *   }
     * ]
     *             """)
     *             .build());
     *         var mongoService = new Service("mongoService", ServiceArgs.builder()
     *             .cluster(foo.id())
     *             .desiredCount(2)
     *             .taskDefinition(mongoTaskDefinition.applyValue(getTaskDefinitionResult -> getTaskDefinitionResult.arn()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTaskDefinition.
     * @return A collection of values returned by getTaskDefinition.
     */
    public suspend fun getTaskDefinition(argument: GetTaskDefinitionPlainArgs):
        GetTaskDefinitionResult =
        getTaskDefinitionResultToKotlin(getTaskDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getTaskDefinition].
     * @param taskDefinition Family for the latest ACTIVE revision, family and revision (family:revision) for a specific revision in the family, the ARN of the task definition to access to.
     * @return A collection of values returned by getTaskDefinition.
     */
    public suspend fun getTaskDefinition(taskDefinition: String): GetTaskDefinitionResult {
        val argument = GetTaskDefinitionPlainArgs(
            taskDefinition = taskDefinition,
        )
        return getTaskDefinitionResultToKotlin(getTaskDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getTaskDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetTaskDefinitionPlainArgs].
     * @return A collection of values returned by getTaskDefinition.
     */
    public suspend
    fun getTaskDefinition(argument: suspend GetTaskDefinitionPlainArgsBuilder.() -> Unit):
        GetTaskDefinitionResult {
        val builder = GetTaskDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTaskDefinitionResultToKotlin(getTaskDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS ECS (Elastic Container) Task Execution. This data source calls the [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API, allowing execution of one-time tasks that don't fit a standard resource lifecycle. See the feature request issue for additional context.
     * > **NOTE on preview operations:** This data source calls the `RunTask` API on every read operation, which means new task(s) may be created from a `pulumi preview` command if all attributes are known. Placing this functionality behind a data source is an intentional trade off to enable use cases requiring a one-time task execution without relying on provisioners. Caution should be taken to ensure the data source is only executed once, or that the resulting tasks can safely run in parallel.
     * {{% examples %}}
     * ## Example Usage
     * {{% /examples %}}
     * @param argument A collection of arguments for invoking getTaskExecution.
     * @return A collection of values returned by getTaskExecution.
     */
    public suspend fun getTaskExecution(argument: GetTaskExecutionPlainArgs): GetTaskExecutionResult =
        getTaskExecutionResultToKotlin(getTaskExecutionPlain(argument.toJava()).await())

    /**
     * @see [getTaskExecution].
     * @param capacityProviderStrategies Set of capacity provider strategies to use for the cluster. See below.
     * @param cluster Short name or full Amazon Resource Name (ARN) of the cluster to run the task on.
     * @param desiredCount Number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.
     * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     * @param enableExecuteCommand Specifies whether to enable Amazon ECS Exec for the tasks within the service.
     * @param group Name of the task group to associate with the task. The default value is the family name of the task definition.
     * @param launchType Launch type on which to run your service. Valid values are `EC2`, `FARGATE`, and `EXTERNAL`.
     * @param networkConfiguration Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     * @param overrides A list of container overrides that specify the name of a container in the specified task definition and the overrides it should receive.
     * @param placementConstraints An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
     * @param placementStrategies The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
     * @param platformVersion The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the `LATEST` platform version is used.
     * @param propagateTags Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. An error will be received if you specify the `SERVICE` option when running a task. Valid values are `TASK_DEFINITION` or `NONE`.
     * @param referenceId The reference ID to use for the task.
     * @param startedBy An optional tag specified when a task is started.
     * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * @param taskDefinition The `family` and `revision` (`family:revision`) or full ARN of the task definition to run. If a revision isn't specified, the latest `ACTIVE` revision is used.
     * The following arguments are optional:
     * @return A collection of values returned by getTaskExecution.
     */
    public suspend fun getTaskExecution(
        capacityProviderStrategies: List<GetTaskExecutionCapacityProviderStrategy>? = null,
        cluster: String,
        desiredCount: Int? = null,
        enableEcsManagedTags: Boolean? = null,
        enableExecuteCommand: Boolean? = null,
        group: String? = null,
        launchType: String? = null,
        networkConfiguration: GetTaskExecutionNetworkConfiguration? = null,
        overrides: GetTaskExecutionOverrides? = null,
        placementConstraints: List<GetTaskExecutionPlacementConstraint>? = null,
        placementStrategies: List<GetTaskExecutionPlacementStrategy>? = null,
        platformVersion: String? = null,
        propagateTags: String? = null,
        referenceId: String? = null,
        startedBy: String? = null,
        tags: Map<String, String>? = null,
        taskDefinition: String,
    ): GetTaskExecutionResult {
        val argument = GetTaskExecutionPlainArgs(
            capacityProviderStrategies = capacityProviderStrategies,
            cluster = cluster,
            desiredCount = desiredCount,
            enableEcsManagedTags = enableEcsManagedTags,
            enableExecuteCommand = enableExecuteCommand,
            group = group,
            launchType = launchType,
            networkConfiguration = networkConfiguration,
            overrides = overrides,
            placementConstraints = placementConstraints,
            placementStrategies = placementStrategies,
            platformVersion = platformVersion,
            propagateTags = propagateTags,
            referenceId = referenceId,
            startedBy = startedBy,
            tags = tags,
            taskDefinition = taskDefinition,
        )
        return getTaskExecutionResultToKotlin(getTaskExecutionPlain(argument.toJava()).await())
    }

    /**
     * @see [getTaskExecution].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetTaskExecutionPlainArgs].
     * @return A collection of values returned by getTaskExecution.
     */
    public suspend
    fun getTaskExecution(argument: suspend GetTaskExecutionPlainArgsBuilder.() -> Unit):
        GetTaskExecutionResult {
        val builder = GetTaskExecutionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTaskExecutionResultToKotlin(getTaskExecutionPlain(builtArgument.toJava()).await())
    }
}
