@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.ServiceArgs.builder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceAlarmsArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceAlarmsArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceCapacityProviderStrategyArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceCapacityProviderStrategyArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceDeploymentCircuitBreakerArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceDeploymentCircuitBreakerArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceDeploymentControllerArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceDeploymentControllerArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceLoadBalancerArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceLoadBalancerArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceNetworkConfigurationArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceNetworkConfigurationArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceOrderedPlacementStrategyArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceOrderedPlacementStrategyArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServicePlacementConstraintArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServicePlacementConstraintArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceServiceConnectConfigurationArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceServiceConnectConfigurationArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceServiceRegistriesArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceServiceRegistriesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * > **Note:** To prevent a race condition during service deletion, make sure to set `depends_on` to the related `aws.iam.RolePolicy`; otherwise, the policy may be destroyed too soon and the ECS service will then get stuck in the `DRAINING` state.
 * Provides an ECS service - effectively a task that is expected to run until an error occurs or a user terminates it (typically a webserver or a database).
 * See [ECS Services section in AWS developer guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceOrderedPlacementStrategyArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceLoadBalancerArgs;
 * import com.pulumi.aws.ecs.inputs.ServicePlacementConstraintArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongo = new Service("mongo", ServiceArgs.builder()
 *             .cluster(aws_ecs_cluster.foo().id())
 *             .taskDefinition(aws_ecs_task_definition.mongo().arn())
 *             .desiredCount(3)
 *             .iamRole(aws_iam_role.foo().arn())
 *             .orderedPlacementStrategies(ServiceOrderedPlacementStrategyArgs.builder()
 *                 .type("binpack")
 *                 .field("cpu")
 *                 .build())
 *             .loadBalancers(ServiceLoadBalancerArgs.builder()
 *                 .targetGroupArn(aws_lb_target_group.foo().arn())
 *                 .containerName("mongo")
 *                 .containerPort(8080)
 *                 .build())
 *             .placementConstraints(ServicePlacementConstraintArgs.builder()
 *                 .type("memberOf")
 *                 .expression("attribute:ecs.availability-zone in [us-west-2a, us-west-2b]")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy.foo())
 *                 .build());
 *     }
 * }
 * ```
 * ### Ignoring Changes to Desired Count
 * You can use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to create an ECS service with an initial count of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .desiredCount(2)
 *             .build());
 *     }
 * }
 * ```
 * ### Daemon Scheduling Strategy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Service("bar", ServiceArgs.builder()
 *             .cluster(aws_ecs_cluster.foo().id())
 *             .taskDefinition(aws_ecs_task_definition.bar().arn())
 *             .schedulingStrategy("DAEMON")
 *             .build());
 *     }
 * }
 * ```
 * ### CloudWatch Deployment Alarms
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceAlarmsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .cluster(aws_ecs_cluster.example().id())
 *             .alarms(ServiceAlarmsArgs.builder()
 *                 .enable(true)
 *                 .rollback(true)
 *                 .alarmNames(aws_cloudwatch_metric_alarm.example().alarm_name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### External Deployment Controller
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceDeploymentControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .cluster(aws_ecs_cluster.example().id())
 *             .deploymentController(ServiceDeploymentControllerArgs.builder()
 *                 .type("EXTERNAL")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECS services using the `name` together with ecs cluster `name`. For example:
 * ```sh
 *  $ pulumi import aws:ecs/service:Service imported cluster-name/service-name
 * ```
 * @property alarms Information about the CloudWatch alarms. See below.
 * @property capacityProviderStrategies Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below.
 * @property cluster ARN of an ECS cluster.
 * @property deploymentCircuitBreaker Configuration block for deployment circuit breaker. See below.
 * @property deploymentController Configuration block for deployment controller configuration. See below.
 * @property deploymentMaximumPercent Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
 * @property deploymentMinimumHealthyPercent Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
 * @property desiredCount Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
 * @property enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
 * @property enableExecuteCommand Specifies whether to enable Amazon ECS Exec for the tasks within the service.
 * @property forceNewDeployment Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
 * @property healthCheckGracePeriodSeconds Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
 * @property iamRole ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
 * @property launchType Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
 * @property loadBalancers Configuration block for load balancers. See below.
 * @property name Name of the service (up to 255 letters, numbers, hyphens, and underscores)
 * The following arguments are optional:
 * @property networkConfiguration Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
 * @property orderedPlacementStrategies Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
 * @property placementConstraints Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
 * @property platformVersion Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
 * @property propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
 * @property schedulingStrategy Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
 * @property serviceConnectConfiguration The ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
 * @property serviceRegistries Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property taskDefinition Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
 * @property triggers Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `timestamp()`. See example above.
 * @property waitForSteadyState If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
 */
public data class ServiceArgs(
    public val alarms: Output<ServiceAlarmsArgs>? = null,
    public val capacityProviderStrategies: Output<List<ServiceCapacityProviderStrategyArgs>>? = null,
    public val cluster: Output<String>? = null,
    public val deploymentCircuitBreaker: Output<ServiceDeploymentCircuitBreakerArgs>? = null,
    public val deploymentController: Output<ServiceDeploymentControllerArgs>? = null,
    public val deploymentMaximumPercent: Output<Int>? = null,
    public val deploymentMinimumHealthyPercent: Output<Int>? = null,
    public val desiredCount: Output<Int>? = null,
    public val enableEcsManagedTags: Output<Boolean>? = null,
    public val enableExecuteCommand: Output<Boolean>? = null,
    public val forceNewDeployment: Output<Boolean>? = null,
    public val healthCheckGracePeriodSeconds: Output<Int>? = null,
    public val iamRole: Output<String>? = null,
    public val launchType: Output<String>? = null,
    public val loadBalancers: Output<List<ServiceLoadBalancerArgs>>? = null,
    public val name: Output<String>? = null,
    public val networkConfiguration: Output<ServiceNetworkConfigurationArgs>? = null,
    public val orderedPlacementStrategies: Output<List<ServiceOrderedPlacementStrategyArgs>>? = null,
    public val placementConstraints: Output<List<ServicePlacementConstraintArgs>>? = null,
    public val platformVersion: Output<String>? = null,
    public val propagateTags: Output<String>? = null,
    public val schedulingStrategy: Output<String>? = null,
    public val serviceConnectConfiguration: Output<ServiceServiceConnectConfigurationArgs>? = null,
    public val serviceRegistries: Output<ServiceServiceRegistriesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskDefinition: Output<String>? = null,
    public val triggers: Output<Map<String, String>>? = null,
    public val waitForSteadyState: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.ServiceArgs> {
    override fun toJava(): com.pulumi.aws.ecs.ServiceArgs = com.pulumi.aws.ecs.ServiceArgs.builder()
        .alarms(alarms?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .capacityProviderStrategies(
            capacityProviderStrategies?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .cluster(cluster?.applyValue({ args0 -> args0 }))
        .deploymentCircuitBreaker(
            deploymentCircuitBreaker?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .deploymentController(
            deploymentController?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .deploymentMaximumPercent(deploymentMaximumPercent?.applyValue({ args0 -> args0 }))
        .deploymentMinimumHealthyPercent(deploymentMinimumHealthyPercent?.applyValue({ args0 -> args0 }))
        .desiredCount(desiredCount?.applyValue({ args0 -> args0 }))
        .enableEcsManagedTags(enableEcsManagedTags?.applyValue({ args0 -> args0 }))
        .enableExecuteCommand(enableExecuteCommand?.applyValue({ args0 -> args0 }))
        .forceNewDeployment(forceNewDeployment?.applyValue({ args0 -> args0 }))
        .healthCheckGracePeriodSeconds(healthCheckGracePeriodSeconds?.applyValue({ args0 -> args0 }))
        .iamRole(iamRole?.applyValue({ args0 -> args0 }))
        .launchType(launchType?.applyValue({ args0 -> args0 }))
        .loadBalancers(
            loadBalancers?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .networkConfiguration(
            networkConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .orderedPlacementStrategies(
            orderedPlacementStrategies?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .placementConstraints(
            placementConstraints?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .platformVersion(platformVersion?.applyValue({ args0 -> args0 }))
        .propagateTags(propagateTags?.applyValue({ args0 -> args0 }))
        .schedulingStrategy(schedulingStrategy?.applyValue({ args0 -> args0 }))
        .serviceConnectConfiguration(
            serviceConnectConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .serviceRegistries(serviceRegistries?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .taskDefinition(taskDefinition?.applyValue({ args0 -> args0 }))
        .triggers(
            triggers?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .waitForSteadyState(waitForSteadyState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var alarms: Output<ServiceAlarmsArgs>? = null

    private var capacityProviderStrategies: Output<List<ServiceCapacityProviderStrategyArgs>>? = null

    private var cluster: Output<String>? = null

    private var deploymentCircuitBreaker: Output<ServiceDeploymentCircuitBreakerArgs>? = null

    private var deploymentController: Output<ServiceDeploymentControllerArgs>? = null

    private var deploymentMaximumPercent: Output<Int>? = null

    private var deploymentMinimumHealthyPercent: Output<Int>? = null

    private var desiredCount: Output<Int>? = null

    private var enableEcsManagedTags: Output<Boolean>? = null

    private var enableExecuteCommand: Output<Boolean>? = null

    private var forceNewDeployment: Output<Boolean>? = null

    private var healthCheckGracePeriodSeconds: Output<Int>? = null

    private var iamRole: Output<String>? = null

    private var launchType: Output<String>? = null

    private var loadBalancers: Output<List<ServiceLoadBalancerArgs>>? = null

    private var name: Output<String>? = null

    private var networkConfiguration: Output<ServiceNetworkConfigurationArgs>? = null

    private var orderedPlacementStrategies: Output<List<ServiceOrderedPlacementStrategyArgs>>? = null

    private var placementConstraints: Output<List<ServicePlacementConstraintArgs>>? = null

    private var platformVersion: Output<String>? = null

    private var propagateTags: Output<String>? = null

    private var schedulingStrategy: Output<String>? = null

    private var serviceConnectConfiguration: Output<ServiceServiceConnectConfigurationArgs>? = null

    private var serviceRegistries: Output<ServiceServiceRegistriesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskDefinition: Output<String>? = null

    private var triggers: Output<Map<String, String>>? = null

    private var waitForSteadyState: Output<Boolean>? = null

    /**
     * @param value Information about the CloudWatch alarms. See below.
     */
    @JvmName("yycrkchhwsukvspo")
    public suspend fun alarms(`value`: Output<ServiceAlarmsArgs>) {
        this.alarms = value
    }

    /**
     * @param value Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below.
     */
    @JvmName("fcxwfjfwrvccrcct")
    public suspend
    fun capacityProviderStrategies(`value`: Output<List<ServiceCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = value
    }

    @JvmName("oixpgawsmbhmaxhv")
    public suspend fun capacityProviderStrategies(
        vararg
        values: Output<ServiceCapacityProviderStrategyArgs>,
    ) {
        this.capacityProviderStrategies = Output.all(values.asList())
    }

    /**
     * @param values Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below.
     */
    @JvmName("lcvtwyykryufbfet")
    public suspend
    fun capacityProviderStrategies(values: List<Output<ServiceCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = Output.all(values)
    }

    /**
     * @param value ARN of an ECS cluster.
     */
    @JvmName("xddggvlobktpjyay")
    public suspend fun cluster(`value`: Output<String>) {
        this.cluster = value
    }

    /**
     * @param value Configuration block for deployment circuit breaker. See below.
     */
    @JvmName("rtfeiklcvysgjxbq")
    public suspend
    fun deploymentCircuitBreaker(`value`: Output<ServiceDeploymentCircuitBreakerArgs>) {
        this.deploymentCircuitBreaker = value
    }

    /**
     * @param value Configuration block for deployment controller configuration. See below.
     */
    @JvmName("sgldnwfxkwhyuqjw")
    public suspend fun deploymentController(`value`: Output<ServiceDeploymentControllerArgs>) {
        this.deploymentController = value
    }

    /**
     * @param value Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
     */
    @JvmName("icojbliooalahcao")
    public suspend fun deploymentMaximumPercent(`value`: Output<Int>) {
        this.deploymentMaximumPercent = value
    }

    /**
     * @param value Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
     */
    @JvmName("uqkvunspieyykred")
    public suspend fun deploymentMinimumHealthyPercent(`value`: Output<Int>) {
        this.deploymentMinimumHealthyPercent = value
    }

    /**
     * @param value Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
     */
    @JvmName("mtrlfrknxetdtbeu")
    public suspend fun desiredCount(`value`: Output<Int>) {
        this.desiredCount = value
    }

    /**
     * @param value Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     */
    @JvmName("rxbpnlfilwkcpuuf")
    public suspend fun enableEcsManagedTags(`value`: Output<Boolean>) {
        this.enableEcsManagedTags = value
    }

    /**
     * @param value Specifies whether to enable Amazon ECS Exec for the tasks within the service.
     */
    @JvmName("vlhphnvyabdkkqwr")
    public suspend fun enableExecuteCommand(`value`: Output<Boolean>) {
        this.enableExecuteCommand = value
    }

    /**
     * @param value Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
     */
    @JvmName("ifnbudhhrjmyuxae")
    public suspend fun forceNewDeployment(`value`: Output<Boolean>) {
        this.forceNewDeployment = value
    }

    /**
     * @param value Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
     */
    @JvmName("tcywjopnqtvqacrx")
    public suspend fun healthCheckGracePeriodSeconds(`value`: Output<Int>) {
        this.healthCheckGracePeriodSeconds = value
    }

    /**
     * @param value ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
     */
    @JvmName("gywhmjvxsxfcoavp")
    public suspend fun iamRole(`value`: Output<String>) {
        this.iamRole = value
    }

    /**
     * @param value Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
     */
    @JvmName("nugdliccjhfinpvm")
    public suspend fun launchType(`value`: Output<String>) {
        this.launchType = value
    }

    /**
     * @param value Configuration block for load balancers. See below.
     */
    @JvmName("tkbjcvipmkgvrnrk")
    public suspend fun loadBalancers(`value`: Output<List<ServiceLoadBalancerArgs>>) {
        this.loadBalancers = value
    }

    @JvmName("durikmkbaegbntlr")
    public suspend fun loadBalancers(vararg values: Output<ServiceLoadBalancerArgs>) {
        this.loadBalancers = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for load balancers. See below.
     */
    @JvmName("efjkrebhhkeqtnqy")
    public suspend fun loadBalancers(values: List<Output<ServiceLoadBalancerArgs>>) {
        this.loadBalancers = Output.all(values)
    }

    /**
     * @param value Name of the service (up to 255 letters, numbers, hyphens, and underscores)
     * The following arguments are optional:
     */
    @JvmName("cxqnxijlswrwiodm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     */
    @JvmName("grvsyisdvvdcynkr")
    public suspend fun networkConfiguration(`value`: Output<ServiceNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("tytydquhxnhjysoj")
    public suspend
    fun orderedPlacementStrategies(`value`: Output<List<ServiceOrderedPlacementStrategyArgs>>) {
        this.orderedPlacementStrategies = value
    }

    @JvmName("eiruxjoftejiopok")
    public suspend fun orderedPlacementStrategies(
        vararg
        values: Output<ServiceOrderedPlacementStrategyArgs>,
    ) {
        this.orderedPlacementStrategies = Output.all(values.asList())
    }

    /**
     * @param values Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("dhjoqqfpshyswaup")
    public suspend
    fun orderedPlacementStrategies(values: List<Output<ServiceOrderedPlacementStrategyArgs>>) {
        this.orderedPlacementStrategies = Output.all(values)
    }

    /**
     * @param value Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("pjyjlyaeymfqlppj")
    public suspend fun placementConstraints(`value`: Output<List<ServicePlacementConstraintArgs>>) {
        this.placementConstraints = value
    }

    @JvmName("luhtjstkvdyokipy")
    public suspend fun placementConstraints(vararg values: Output<ServicePlacementConstraintArgs>) {
        this.placementConstraints = Output.all(values.asList())
    }

    /**
     * @param values Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("pytvvbomvpfwdffs")
    public suspend fun placementConstraints(values: List<Output<ServicePlacementConstraintArgs>>) {
        this.placementConstraints = Output.all(values)
    }

    /**
     * @param value Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    @JvmName("nnimdhmuumqdbhek")
    public suspend fun platformVersion(`value`: Output<String>) {
        this.platformVersion = value
    }

    /**
     * @param value Specifies whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
     */
    @JvmName("xvxtingrxonjyvsa")
    public suspend fun propagateTags(`value`: Output<String>) {
        this.propagateTags = value
    }

    /**
     * @param value Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
     */
    @JvmName("oqtnqfuoaoneaxwr")
    public suspend fun schedulingStrategy(`value`: Output<String>) {
        this.schedulingStrategy = value
    }

    /**
     * @param value The ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
     */
    @JvmName("yhqwuxqiqexcvlcl")
    public suspend
    fun serviceConnectConfiguration(`value`: Output<ServiceServiceConnectConfigurationArgs>) {
        this.serviceConnectConfiguration = value
    }

    /**
     * @param value Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
     */
    @JvmName("arbxdrlvgsogmwsu")
    public suspend fun serviceRegistries(`value`: Output<ServiceServiceRegistriesArgs>) {
        this.serviceRegistries = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xpsxwsfooxngmcvw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
     */
    @JvmName("wvcknsocvhhoyoqd")
    public suspend fun taskDefinition(`value`: Output<String>) {
        this.taskDefinition = value
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `timestamp()`. See example above.
     */
    @JvmName("lscisbiuguwuukga")
    public suspend fun triggers(`value`: Output<Map<String, String>>) {
        this.triggers = value
    }

    /**
     * @param value If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
     */
    @JvmName("swrqmrftpskjwsxv")
    public suspend fun waitForSteadyState(`value`: Output<Boolean>) {
        this.waitForSteadyState = value
    }

    /**
     * @param value Information about the CloudWatch alarms. See below.
     */
    @JvmName("rbjunmlyjojtxmqf")
    public suspend fun alarms(`value`: ServiceAlarmsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param argument Information about the CloudWatch alarms. See below.
     */
    @JvmName("dscucvpnerjcbsnc")
    public suspend fun alarms(argument: suspend ServiceAlarmsArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceAlarmsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alarms = mapped
    }

    /**
     * @param value Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below.
     */
    @JvmName("mbtuboicaykhymwm")
    public suspend
    fun capacityProviderStrategies(`value`: List<ServiceCapacityProviderStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below.
     */
    @JvmName("yaqxyaytteorcfmw")
    public suspend
    fun capacityProviderStrategies(argument: List<suspend ServiceCapacityProviderStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceCapacityProviderStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below.
     */
    @JvmName("msphdpfodafihfrx")
    public suspend fun capacityProviderStrategies(
        vararg
        argument: suspend ServiceCapacityProviderStrategyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceCapacityProviderStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below.
     */
    @JvmName("lddwmobbixwjchqx")
    public suspend
    fun capacityProviderStrategies(argument: suspend ServiceCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceCapacityProviderStrategyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param values Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below.
     */
    @JvmName("hprdxideqmohildy")
    public suspend fun capacityProviderStrategies(
        vararg
        values: ServiceCapacityProviderStrategyArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param value ARN of an ECS cluster.
     */
    @JvmName("kpdxtysbhcydsulr")
    public suspend fun cluster(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cluster = mapped
    }

    /**
     * @param value Configuration block for deployment circuit breaker. See below.
     */
    @JvmName("mlxilwoscdneaxmi")
    public suspend fun deploymentCircuitBreaker(`value`: ServiceDeploymentCircuitBreakerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentCircuitBreaker = mapped
    }

    /**
     * @param argument Configuration block for deployment circuit breaker. See below.
     */
    @JvmName("xiquyemoduhnqpwm")
    public suspend
    fun deploymentCircuitBreaker(argument: suspend ServiceDeploymentCircuitBreakerArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceDeploymentCircuitBreakerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentCircuitBreaker = mapped
    }

    /**
     * @param value Configuration block for deployment controller configuration. See below.
     */
    @JvmName("xwslbekduigabfao")
    public suspend fun deploymentController(`value`: ServiceDeploymentControllerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentController = mapped
    }

    /**
     * @param argument Configuration block for deployment controller configuration. See below.
     */
    @JvmName("fryrwfkflxwdscnx")
    public suspend
    fun deploymentController(argument: suspend ServiceDeploymentControllerArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceDeploymentControllerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentController = mapped
    }

    /**
     * @param value Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
     */
    @JvmName("ntihesptdipqnfev")
    public suspend fun deploymentMaximumPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentMaximumPercent = mapped
    }

    /**
     * @param value Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
     */
    @JvmName("cmpybyffiupcstnl")
    public suspend fun deploymentMinimumHealthyPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentMinimumHealthyPercent = mapped
    }

    /**
     * @param value Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
     */
    @JvmName("oocrgblorsjnkvas")
    public suspend fun desiredCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredCount = mapped
    }

    /**
     * @param value Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     */
    @JvmName("oiyfqccpiepxdlpd")
    public suspend fun enableEcsManagedTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEcsManagedTags = mapped
    }

    /**
     * @param value Specifies whether to enable Amazon ECS Exec for the tasks within the service.
     */
    @JvmName("peuldlytdwirdkih")
    public suspend fun enableExecuteCommand(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableExecuteCommand = mapped
    }

    /**
     * @param value Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
     */
    @JvmName("jwfwqsvhlwlbprtu")
    public suspend fun forceNewDeployment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceNewDeployment = mapped
    }

    /**
     * @param value Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
     */
    @JvmName("yvemvovamoflbuow")
    public suspend fun healthCheckGracePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckGracePeriodSeconds = mapped
    }

    /**
     * @param value ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
     */
    @JvmName("bmuyhabrkgmwhuut")
    public suspend fun iamRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRole = mapped
    }

    /**
     * @param value Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
     */
    @JvmName("uwaqiworhrkatbgm")
    public suspend fun launchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchType = mapped
    }

    /**
     * @param value Configuration block for load balancers. See below.
     */
    @JvmName("nlsgeergagxqltiq")
    public suspend fun loadBalancers(`value`: List<ServiceLoadBalancerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param argument Configuration block for load balancers. See below.
     */
    @JvmName("lxrpxfkovwrwfisd")
    public suspend
    fun loadBalancers(argument: List<suspend ServiceLoadBalancerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceLoadBalancerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancers = mapped
    }

    /**
     * @param argument Configuration block for load balancers. See below.
     */
    @JvmName("oagqqtkgoiktflim")
    public suspend fun loadBalancers(
        vararg
        argument: suspend ServiceLoadBalancerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceLoadBalancerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancers = mapped
    }

    /**
     * @param argument Configuration block for load balancers. See below.
     */
    @JvmName("jwwagcbvjwjtqmdu")
    public suspend fun loadBalancers(argument: suspend ServiceLoadBalancerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceLoadBalancerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancers = mapped
    }

    /**
     * @param values Configuration block for load balancers. See below.
     */
    @JvmName("jqcpkblddpchnrgm")
    public suspend fun loadBalancers(vararg values: ServiceLoadBalancerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param value Name of the service (up to 255 letters, numbers, hyphens, and underscores)
     * The following arguments are optional:
     */
    @JvmName("pvwgaefikkvrutvq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     */
    @JvmName("kfyjpfcwrnasqedb")
    public suspend fun networkConfiguration(`value`: ServiceNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     */
    @JvmName("ishukhupslexiofk")
    public suspend
    fun networkConfiguration(argument: suspend ServiceNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("koenpladsbnkhgyb")
    public suspend
    fun orderedPlacementStrategies(`value`: List<ServiceOrderedPlacementStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param argument Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("rewggellppiimpre")
    public suspend
    fun orderedPlacementStrategies(argument: List<suspend ServiceOrderedPlacementStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceOrderedPlacementStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param argument Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("ndeybxtrcktpomro")
    public suspend fun orderedPlacementStrategies(
        vararg
        argument: suspend ServiceOrderedPlacementStrategyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceOrderedPlacementStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param argument Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("vnmkphpknqkjjypy")
    public suspend
    fun orderedPlacementStrategies(argument: suspend ServiceOrderedPlacementStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceOrderedPlacementStrategyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param values Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("ljgrqtjlbwrrnitu")
    public suspend fun orderedPlacementStrategies(
        vararg
        values: ServiceOrderedPlacementStrategyArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param value Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("qryhokwniahngelb")
    public suspend fun placementConstraints(`value`: List<ServicePlacementConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param argument Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("imirfgabnshnlqoy")
    public suspend
    fun placementConstraints(argument: List<suspend ServicePlacementConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServicePlacementConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("gfbhucvpjeyteeqj")
    public suspend fun placementConstraints(
        vararg
        argument: suspend ServicePlacementConstraintArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServicePlacementConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("myvyymumwsuagyif")
    public suspend
    fun placementConstraints(argument: suspend ServicePlacementConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServicePlacementConstraintArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param values Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("yioocbbcwevmnwyj")
    public suspend fun placementConstraints(vararg values: ServicePlacementConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param value Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    @JvmName("iodxmhgvojspktdn")
    public suspend fun platformVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformVersion = mapped
    }

    /**
     * @param value Specifies whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
     */
    @JvmName("dotssoounaiyntcr")
    public suspend fun propagateTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagateTags = mapped
    }

    /**
     * @param value Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
     */
    @JvmName("thymikjbwellbpxs")
    public suspend fun schedulingStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulingStrategy = mapped
    }

    /**
     * @param value The ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
     */
    @JvmName("rxwepvltqbxxkdpo")
    public suspend fun serviceConnectConfiguration(`value`: ServiceServiceConnectConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceConnectConfiguration = mapped
    }

    /**
     * @param argument The ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
     */
    @JvmName("mtgdeodxugqdhrer")
    public suspend
    fun serviceConnectConfiguration(argument: suspend ServiceServiceConnectConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceServiceConnectConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serviceConnectConfiguration = mapped
    }

    /**
     * @param value Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
     */
    @JvmName("otkktvujoeylsmrk")
    public suspend fun serviceRegistries(`value`: ServiceServiceRegistriesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRegistries = mapped
    }

    /**
     * @param argument Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
     */
    @JvmName("ovckyumpmiswtaro")
    public suspend
    fun serviceRegistries(argument: suspend ServiceServiceRegistriesArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceServiceRegistriesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceRegistries = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nbngoiqguuffsoqn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hnkwwnqcktrhrcgu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
     */
    @JvmName("rgycqtaglpdqmuik")
    public suspend fun taskDefinition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskDefinition = mapped
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `timestamp()`. See example above.
     */
    @JvmName("mjvsjcfphppcimyr")
    public suspend fun triggers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param values Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `timestamp()`. See example above.
     */
    @JvmName("hiprasnmjykdwlrj")
    public fun triggers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param value If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
     */
    @JvmName("rcrxcfqkcjamludn")
    public suspend fun waitForSteadyState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForSteadyState = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        alarms = alarms,
        capacityProviderStrategies = capacityProviderStrategies,
        cluster = cluster,
        deploymentCircuitBreaker = deploymentCircuitBreaker,
        deploymentController = deploymentController,
        deploymentMaximumPercent = deploymentMaximumPercent,
        deploymentMinimumHealthyPercent = deploymentMinimumHealthyPercent,
        desiredCount = desiredCount,
        enableEcsManagedTags = enableEcsManagedTags,
        enableExecuteCommand = enableExecuteCommand,
        forceNewDeployment = forceNewDeployment,
        healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds,
        iamRole = iamRole,
        launchType = launchType,
        loadBalancers = loadBalancers,
        name = name,
        networkConfiguration = networkConfiguration,
        orderedPlacementStrategies = orderedPlacementStrategies,
        placementConstraints = placementConstraints,
        platformVersion = platformVersion,
        propagateTags = propagateTags,
        schedulingStrategy = schedulingStrategy,
        serviceConnectConfiguration = serviceConnectConfiguration,
        serviceRegistries = serviceRegistries,
        tags = tags,
        taskDefinition = taskDefinition,
        triggers = triggers,
        waitForSteadyState = waitForSteadyState,
    )
}
