@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Tag].
 */
@PulumiTagMarker
public class TagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagArgs = TagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagArgsBuilder.() -> Unit) {
        val builder = TagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Tag {
        val builtJavaResource = com.pulumi.aws.ecs.Tag(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Tag(builtJavaResource)
    }
}

/**
 * Manages an individual ECS resource tag. This resource should only be used in cases where ECS resources are created outside the provider (e.g., ECS Clusters implicitly created by Batch Compute Environments).
 * > **NOTE:** This tagging resource should not be combined with the resource for managing the parent resource. For example, using `aws.ecs.Cluster` and `aws.ecs.Tag` to manage tags of the same ECS Cluster will cause a perpetual difference where the `aws.ecs.Cluster` resource will try to remove the tag being added by the `aws.ecs.Tag` resource.
 * > **NOTE:** This tagging resource does not use the provider `ignore_tags` configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.ComputeEnvironment;
 * import com.pulumi.aws.batch.ComputeEnvironmentArgs;
 * import com.pulumi.aws.ecs.Tag;
 * import com.pulumi.aws.ecs.TagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleComputeEnvironment = new ComputeEnvironment("exampleComputeEnvironment", ComputeEnvironmentArgs.builder()
 *             .computeEnvironmentName("example")
 *             .serviceRole(aws_iam_role.example().arn())
 *             .type("UNMANAGED")
 *             .build());
 *         var exampleTag = new Tag("exampleTag", TagArgs.builder()
 *             .resourceArn(exampleComputeEnvironment.ecsClusterArn())
 *             .key("Name")
 *             .value("Hello World")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ecs_tag` using the ECS resource identifier and key, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ecs/tag:Tag example arn:aws:ecs:us-east-1:123456789012:cluster/example,Name
 * ```
 *
 */
public class Tag internal constructor(
    override val javaResource: com.pulumi.aws.ecs.Tag,
) : KotlinCustomResource(javaResource, TagMapper) {
    /**
     * Tag name.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the ECS resource to tag.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * Tag value.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object TagMapper : ResourceMapper<Tag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecs.Tag::class == javaResource::class

    override fun map(javaResource: Resource): Tag = Tag(javaResource as com.pulumi.aws.ecs.Tag)
}

/**
 * @see [Tag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Tag].
 */
public suspend fun tag(name: String, block: suspend TagResourceBuilder.() -> Unit): Tag {
    val builder = TagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Tag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tag(name: String): Tag {
    val builder = TagResourceBuilder()
    builder.name(name)
    return builder.build()
}
