@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.TagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an individual ECS resource tag. This resource should only be used in cases where ECS resources are created outside the provider (e.g., ECS Clusters implicitly created by Batch Compute Environments).
 * > **NOTE:** This tagging resource should not be combined with the resource for managing the parent resource. For example, using `aws.ecs.Cluster` and `aws.ecs.Tag` to manage tags of the same ECS Cluster will cause a perpetual difference where the `aws.ecs.Cluster` resource will try to remove the tag being added by the `aws.ecs.Tag` resource.
 * > **NOTE:** This tagging resource does not use the provider `ignore_tags` configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.ComputeEnvironment;
 * import com.pulumi.aws.batch.ComputeEnvironmentArgs;
 * import com.pulumi.aws.ecs.Tag;
 * import com.pulumi.aws.ecs.TagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleComputeEnvironment = new ComputeEnvironment("exampleComputeEnvironment", ComputeEnvironmentArgs.builder()
 *             .computeEnvironmentName("example")
 *             .serviceRole(aws_iam_role.example().arn())
 *             .type("UNMANAGED")
 *             .build());
 *         var exampleTag = new Tag("exampleTag", TagArgs.builder()
 *             .resourceArn(exampleComputeEnvironment.ecsClusterArn())
 *             .key("Name")
 *             .value("Hello World")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ecs_tag` using the ECS resource identifier and key, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ecs/tag:Tag example arn:aws:ecs:us-east-1:123456789012:cluster/example,Name
 * ```
 * @property key Tag name.
 * @property resourceArn Amazon Resource Name (ARN) of the ECS resource to tag.
 * @property value Tag value.
 */
public data class TagArgs(
    public val key: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.TagArgs> {
    override fun toJava(): com.pulumi.aws.ecs.TagArgs = com.pulumi.aws.ecs.TagArgs.builder()
        .key(key?.applyValue({ args0 -> args0 }))
        .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
        .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagArgs].
 */
@PulumiTagMarker
public class TagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var resourceArn: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Tag name.
     */
    @JvmName("yvdaitixescmkyio")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the ECS resource to tag.
     */
    @JvmName("dtwyuiphklemwyxs")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value Tag value.
     */
    @JvmName("wwoeigmpetmwpesv")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Tag name.
     */
    @JvmName("ksooaajsrgohqaey")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the ECS resource to tag.
     */
    @JvmName("lqvjcppegjbgcfpm")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value Tag value.
     */
    @JvmName("mhcwkxyarasmsaam")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TagArgs = TagArgs(
        key = key,
        resourceArn = resourceArn,
        `value` = `value`,
    )
}
