@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionEphemeralStorage
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionInferenceAccelerator
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionPlacementConstraint
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionProxyConfiguration
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionRuntimePlatform
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionVolume
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionEphemeralStorage.Companion.toKotlin as taskDefinitionEphemeralStorageToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionInferenceAccelerator.Companion.toKotlin as taskDefinitionInferenceAcceleratorToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionPlacementConstraint.Companion.toKotlin as taskDefinitionPlacementConstraintToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionProxyConfiguration.Companion.toKotlin as taskDefinitionProxyConfigurationToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionRuntimePlatform.Companion.toKotlin as taskDefinitionRuntimePlatformToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionVolume.Companion.toKotlin as taskDefinitionVolumeToKotlin

/**
 * Builder for [TaskDefinition].
 */
@PulumiTagMarker
public class TaskDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TaskDefinitionArgs = TaskDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TaskDefinitionArgsBuilder.() -> Unit) {
        val builder = TaskDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TaskDefinition {
        val builtJavaResource = com.pulumi.aws.ecs.TaskDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TaskDefinition(builtJavaResource)
    }
}

/**
 * Manages a revision of an ECS task definition to be used in `aws.ecs.Service`.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionPlacementConstraintArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(serializeJson(
 *                 jsonArray(
 *                     jsonObject(
 *                         jsonProperty("name", "first"),
 *                         jsonProperty("image", "service-first"),
 *                         jsonProperty("cpu", 10),
 *                         jsonProperty("memory", 512),
 *                         jsonProperty("essential", true),
 *                         jsonProperty("portMappings", jsonArray(jsonObject(
 *                             jsonProperty("containerPort", 80),
 *                             jsonProperty("hostPort", 80)
 *                         )))
 *                     ),
 *                     jsonObject(
 *                         jsonProperty("name", "second"),
 *                         jsonProperty("image", "service-second"),
 *                         jsonProperty("cpu", 10),
 *                         jsonProperty("memory", 256),
 *                         jsonProperty("essential", true),
 *                         jsonProperty("portMappings", jsonArray(jsonObject(
 *                             jsonProperty("containerPort", 443),
 *                             jsonProperty("hostPort", 443)
 *                         )))
 *                     )
 *                 )))
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .hostPath("/ecs/service-storage")
 *                 .build())
 *             .placementConstraints(TaskDefinitionPlacementConstraintArgs.builder()
 *                 .type("memberOf")
 *                 .expression("attribute:ecs.availability-zone in [us-west-2a, us-west-2b]")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With AppMesh Proxy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionProxyConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(Files.readString(Paths.get("task-definitions/service.json")))
 *             .proxyConfiguration(TaskDefinitionProxyConfigurationArgs.builder()
 *                 .type("APPMESH")
 *                 .containerName("applicationContainerName")
 *                 .properties(Map.ofEntries(
 *                     Map.entry("AppPorts", "8080"),
 *                     Map.entry("EgressIgnoredIPs", "169.254.170.2,169.254.169.254"),
 *                     Map.entry("IgnoredUID", "1337"),
 *                     Map.entry("ProxyEgressPort", 15001),
 *                     Map.entry("ProxyIngressPort", 15000)
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `docker_volume_configuration`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeDockerVolumeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(Files.readString(Paths.get("task-definitions/service.json")))
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .dockerVolumeConfiguration(TaskDefinitionVolumeDockerVolumeConfigurationArgs.builder()
 *                     .scope("shared")
 *                     .autoprovision(true)
 *                     .driver("local")
 *                     .driverOpts(Map.ofEntries(
 *                         Map.entry("type", "nfs"),
 *                         Map.entry("device", String.format("%s:/", aws_efs_file_system.fs().dns_name())),
 *                         Map.entry("o", String.format("addr=%s,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport", aws_efs_file_system.fs().dns_name()))
 *                     ))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `efs_volume_configuration`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(Files.readString(Paths.get("task-definitions/service.json")))
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .efsVolumeConfiguration(TaskDefinitionVolumeEfsVolumeConfigurationArgs.builder()
 *                     .fileSystemId(aws_efs_file_system.fs().id())
 *                     .rootDirectory("/opt/data")
 *                     .transitEncryption("ENABLED")
 *                     .transitEncryptionPort(2999)
 *                     .authorizationConfig(TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs.builder()
 *                         .accessPointId(aws_efs_access_point.test().id())
 *                         .iam("ENABLED")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `fsx_windows_file_server_volume_configuration`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new SecretVersion("test", SecretVersionArgs.builder()
 *             .secretId(aws_secretsmanager_secret.test().id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("username", "admin"),
 *                     jsonProperty("password", aws_directory_service_directory.test().password())
 *                 )))
 *             .build());
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(Files.readString(Paths.get("task-definitions/service.json")))
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .fsxWindowsFileServerVolumeConfiguration(TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs.builder()
 *                     .fileSystemId(aws_fsx_windows_file_system.test().id())
 *                     .rootDirectory("\\data")
 *                     .authorizationConfig(TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs.builder()
 *                         .credentialsParameter(test.arn())
 *                         .domain(aws_directory_service_directory.test().name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `container_definitions` and `inference_accelerator`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionInferenceAcceleratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TaskDefinition("test", TaskDefinitionArgs.builder()
 *             .containerDefinitions("""
 * [
 *   {
 *     "cpu": 10,
 *     "command": ["sleep", "10"],
 *     "entryPoint": ["/"],
 *     "environment": [
 *       {"name": "VARNAME", "value": "VARVAL"}
 *     ],
 *     "essential": true,
 *     "image": "jenkins",
 *     "memory": 128,
 *     "name": "jenkins",
 *     "portMappings": [
 *       {
 *         "containerPort": 80,
 *         "hostPort": 8080
 *       }
 *     ],
 *         "resourceRequirements":[
 *             {
 *                 "type":"InferenceAccelerator",
 *                 "value":"device_1"
 *             }
 *         ]
 *   }
 * ]
 *             """)
 *             .family("test")
 *             .inferenceAccelerators(TaskDefinitionInferenceAcceleratorArgs.builder()
 *                 .deviceName("device_1")
 *                 .deviceType("eia1.medium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `runtime_platform` and `fargate`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionRuntimePlatformArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TaskDefinition("test", TaskDefinitionArgs.builder()
 *             .containerDefinitions("""
 * [
 *   {
 *     "name": "iis",
 *     "image": "mcr.microsoft.com/windows/servercore/iis",
 *     "cpu": 1024,
 *     "memory": 2048,
 *     "essential": true
 *   }
 * ]
 *             """)
 *             .cpu(1024)
 *             .family("test")
 *             .memory(2048)
 *             .networkMode("awsvpc")
 *             .requiresCompatibilities("FARGATE")
 *             .runtimePlatform(TaskDefinitionRuntimePlatformArgs.builder()
 *                 .cpuArchitecture("X86_64")
 *                 .operatingSystemFamily("WINDOWS_SERVER_2019_CORE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECS Task Definitions using their ARNs. For example:
 * ```sh
 *  $ pulumi import aws:ecs/taskDefinition:TaskDefinition example arn:aws:ecs:us-east-1:012345678910:task-definition/mytaskfamily:123
 * ```
 *
 */
public class TaskDefinition internal constructor(
    override val javaResource: com.pulumi.aws.ecs.TaskDefinition,
) : KotlinCustomResource(javaResource, TaskDefinitionMapper) {
    /**
     * Full ARN of the Task Definition (including both `family` and `revision`).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN of the Task Definition with the trailing `revision` removed. This may be useful for situations where the latest task definition is always desired. If a revision isn't specified, the latest ACTIVE revision is used. See the [AWS documentation](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_StartTask.html#ECS-StartTask-request-taskDefinition) for details.
     */
    public val arnWithoutRevision: Output<String>
        get() = javaResource.arnWithoutRevision().applyValue({ args0 -> args0 })

    /**
     * A list of valid [container definitions](http://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/APIReference/API_ContainerDefinition&#46;html) provided as a single valid JSON document&#46; Please note that you should only provide values that are part of the container definition document&#46; For a detailed description of what parameters are available, see the [Task Definition Parameters](https://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/developerguide/task_definition_parameters&#46;html) section from the official [Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide).
     */
    public val containerDefinitions: Output<String>
        get() = javaResource.containerDefinitions().applyValue({ args0 -> args0 })

    /**
     * Number of cpu units used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
     */
    public val cpu: Output<String>?
        get() = javaResource.cpu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
     */
    public val ephemeralStorage: Output<TaskDefinitionEphemeralStorage>?
        get() = javaResource.ephemeralStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> taskDefinitionEphemeralStorageToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ARN of the task execution role that the Amazon ECS container agent and the Docker daemon can assume.
     */
    public val executionRoleArn: Output<String>?
        get() = javaResource.executionRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique name for your task definition.
     * The following arguments are optional:
     */
    public val family: Output<String>
        get() = javaResource.family().applyValue({ args0 -> args0 })

    /**
     * Configuration block(s) with Inference Accelerators settings. Detailed below.
     */
    public val inferenceAccelerators: Output<List<TaskDefinitionInferenceAccelerator>>?
        get() = javaResource.inferenceAccelerators().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        taskDefinitionInferenceAcceleratorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
     */
    public val ipcMode: Output<String>?
        get() = javaResource.ipcMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Amount (in MiB) of memory used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
     */
    public val memory: Output<String>?
        get() = javaResource.memory().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
     */
    public val networkMode: Output<String>
        get() = javaResource.networkMode().applyValue({ args0 -> args0 })

    /**
     * Process namespace to use for the containers in the task. The valid values are `host` and `task`.
     */
    public val pidMode: Output<String>?
        get() = javaResource.pidMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
     */
    public val placementConstraints: Output<List<TaskDefinitionPlacementConstraint>>?
        get() = javaResource.placementConstraints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        taskDefinitionPlacementConstraintToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block for the App Mesh proxy. Detailed below.
     */
    public val proxyConfiguration: Output<TaskDefinitionProxyConfiguration>?
        get() = javaResource.proxyConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> taskDefinitionProxyConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Set of launch types required by the task. The valid values are `EC2` and `FARGATE`.
     */
    public val requiresCompatibilities: Output<List<String>>?
        get() = javaResource.requiresCompatibilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Revision of the task in a particular family.
     */
    public val revision: Output<Int>
        get() = javaResource.revision().applyValue({ args0 -> args0 })

    /**
     * Configuration block for runtime_platform that containers in your task may use.
     */
    public val runtimePlatform: Output<TaskDefinitionRuntimePlatform>?
        get() = javaResource.runtimePlatform().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> taskDefinitionRuntimePlatformToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
     */
    public val skipDestroy: Output<Boolean>?
        get() = javaResource.skipDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ARN of IAM role that allows your Amazon ECS container task to make calls to other AWS services.
     */
    public val taskRoleArn: Output<String>?
        get() = javaResource.taskRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for volumes that containers in your task may use. Detailed below.
     */
    public val volumes: Output<List<TaskDefinitionVolume>>?
        get() = javaResource.volumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> taskDefinitionVolumeToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object TaskDefinitionMapper : ResourceMapper<TaskDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecs.TaskDefinition::class == javaResource::class

    override fun map(javaResource: Resource): TaskDefinition = TaskDefinition(
        javaResource as
            com.pulumi.aws.ecs.TaskDefinition,
    )
}

/**
 * @see [TaskDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TaskDefinition].
 */
public suspend fun taskDefinition(
    name: String,
    block: suspend TaskDefinitionResourceBuilder.() -> Unit,
): TaskDefinition {
    val builder = TaskDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TaskDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun taskDefinition(name: String): TaskDefinition {
    val builder = TaskDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
