@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.TaskDefinitionArgs.builder
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionEphemeralStorageArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionEphemeralStorageArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionInferenceAcceleratorArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionInferenceAcceleratorArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionPlacementConstraintArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionPlacementConstraintArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionProxyConfigurationArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionProxyConfigurationArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionRuntimePlatformArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionRuntimePlatformArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionVolumeArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskDefinitionVolumeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a revision of an ECS task definition to be used in `aws.ecs.Service`.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionPlacementConstraintArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(serializeJson(
 *                 jsonArray(
 *                     jsonObject(
 *                         jsonProperty("name", "first"),
 *                         jsonProperty("image", "service-first"),
 *                         jsonProperty("cpu", 10),
 *                         jsonProperty("memory", 512),
 *                         jsonProperty("essential", true),
 *                         jsonProperty("portMappings", jsonArray(jsonObject(
 *                             jsonProperty("containerPort", 80),
 *                             jsonProperty("hostPort", 80)
 *                         )))
 *                     ),
 *                     jsonObject(
 *                         jsonProperty("name", "second"),
 *                         jsonProperty("image", "service-second"),
 *                         jsonProperty("cpu", 10),
 *                         jsonProperty("memory", 256),
 *                         jsonProperty("essential", true),
 *                         jsonProperty("portMappings", jsonArray(jsonObject(
 *                             jsonProperty("containerPort", 443),
 *                             jsonProperty("hostPort", 443)
 *                         )))
 *                     )
 *                 )))
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .hostPath("/ecs/service-storage")
 *                 .build())
 *             .placementConstraints(TaskDefinitionPlacementConstraintArgs.builder()
 *                 .type("memberOf")
 *                 .expression("attribute:ecs.availability-zone in [us-west-2a, us-west-2b]")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With AppMesh Proxy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionProxyConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(Files.readString(Paths.get("task-definitions/service.json")))
 *             .proxyConfiguration(TaskDefinitionProxyConfigurationArgs.builder()
 *                 .type("APPMESH")
 *                 .containerName("applicationContainerName")
 *                 .properties(Map.ofEntries(
 *                     Map.entry("AppPorts", "8080"),
 *                     Map.entry("EgressIgnoredIPs", "169.254.170.2,169.254.169.254"),
 *                     Map.entry("IgnoredUID", "1337"),
 *                     Map.entry("ProxyEgressPort", 15001),
 *                     Map.entry("ProxyIngressPort", 15000)
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `docker_volume_configuration`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeDockerVolumeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(Files.readString(Paths.get("task-definitions/service.json")))
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .dockerVolumeConfiguration(TaskDefinitionVolumeDockerVolumeConfigurationArgs.builder()
 *                     .scope("shared")
 *                     .autoprovision(true)
 *                     .driver("local")
 *                     .driverOpts(Map.ofEntries(
 *                         Map.entry("type", "nfs"),
 *                         Map.entry("device", String.format("%s:/", aws_efs_file_system.fs().dns_name())),
 *                         Map.entry("o", String.format("addr=%s,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport", aws_efs_file_system.fs().dns_name()))
 *                     ))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `efs_volume_configuration`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(Files.readString(Paths.get("task-definitions/service.json")))
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .efsVolumeConfiguration(TaskDefinitionVolumeEfsVolumeConfigurationArgs.builder()
 *                     .fileSystemId(aws_efs_file_system.fs().id())
 *                     .rootDirectory("/opt/data")
 *                     .transitEncryption("ENABLED")
 *                     .transitEncryptionPort(2999)
 *                     .authorizationConfig(TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs.builder()
 *                         .accessPointId(aws_efs_access_point.test().id())
 *                         .iam("ENABLED")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `fsx_windows_file_server_volume_configuration`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new SecretVersion("test", SecretVersionArgs.builder()
 *             .secretId(aws_secretsmanager_secret.test().id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("username", "admin"),
 *                     jsonProperty("password", aws_directory_service_directory.test().password())
 *                 )))
 *             .build());
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(Files.readString(Paths.get("task-definitions/service.json")))
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .fsxWindowsFileServerVolumeConfiguration(TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs.builder()
 *                     .fileSystemId(aws_fsx_windows_file_system.test().id())
 *                     .rootDirectory("\\data")
 *                     .authorizationConfig(TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs.builder()
 *                         .credentialsParameter(test.arn())
 *                         .domain(aws_directory_service_directory.test().name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `container_definitions` and `inference_accelerator`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionInferenceAcceleratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TaskDefinition("test", TaskDefinitionArgs.builder()
 *             .containerDefinitions("""
 * [
 *   {
 *     "cpu": 10,
 *     "command": ["sleep", "10"],
 *     "entryPoint": ["/"],
 *     "environment": [
 *       {"name": "VARNAME", "value": "VARVAL"}
 *     ],
 *     "essential": true,
 *     "image": "jenkins",
 *     "memory": 128,
 *     "name": "jenkins",
 *     "portMappings": [
 *       {
 *         "containerPort": 80,
 *         "hostPort": 8080
 *       }
 *     ],
 *         "resourceRequirements":[
 *             {
 *                 "type":"InferenceAccelerator",
 *                 "value":"device_1"
 *             }
 *         ]
 *   }
 * ]
 *             """)
 *             .family("test")
 *             .inferenceAccelerators(TaskDefinitionInferenceAcceleratorArgs.builder()
 *                 .deviceName("device_1")
 *                 .deviceType("eia1.medium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Using `runtime_platform` and `fargate`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionRuntimePlatformArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TaskDefinition("test", TaskDefinitionArgs.builder()
 *             .containerDefinitions("""
 * [
 *   {
 *     "name": "iis",
 *     "image": "mcr.microsoft.com/windows/servercore/iis",
 *     "cpu": 1024,
 *     "memory": 2048,
 *     "essential": true
 *   }
 * ]
 *             """)
 *             .cpu(1024)
 *             .family("test")
 *             .memory(2048)
 *             .networkMode("awsvpc")
 *             .requiresCompatibilities("FARGATE")
 *             .runtimePlatform(TaskDefinitionRuntimePlatformArgs.builder()
 *                 .cpuArchitecture("X86_64")
 *                 .operatingSystemFamily("WINDOWS_SERVER_2019_CORE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECS Task Definitions using their ARNs. For example:
 * ```sh
 *  $ pulumi import aws:ecs/taskDefinition:TaskDefinition example arn:aws:ecs:us-east-1:012345678910:task-definition/mytaskfamily:123
 * ```
 * @property containerDefinitions A list of valid [container definitions](http://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/APIReference/API_ContainerDefinition&#46;html) provided as a single valid JSON document&#46; Please note that you should only provide values that are part of the container definition document&#46; For a detailed description of what parameters are available, see the [Task Definition Parameters](https://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/developerguide/task_definition_parameters&#46;html) section from the official [Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide).
 * @property cpu Number of cpu units used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
 * @property ephemeralStorage The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
 * @property executionRoleArn ARN of the task execution role that the Amazon ECS container agent and the Docker daemon can assume.
 * @property family A unique name for your task definition.
 * The following arguments are optional:
 * @property inferenceAccelerators Configuration block(s) with Inference Accelerators settings. Detailed below.
 * @property ipcMode IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
 * @property memory Amount (in MiB) of memory used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
 * @property networkMode Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
 * @property pidMode Process namespace to use for the containers in the task. The valid values are `host` and `task`.
 * @property placementConstraints Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
 * @property proxyConfiguration Configuration block for the App Mesh proxy. Detailed below.
 * @property requiresCompatibilities Set of launch types required by the task. The valid values are `EC2` and `FARGATE`.
 * @property runtimePlatform Configuration block for runtime_platform that containers in your task may use.
 * @property skipDestroy Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property taskRoleArn ARN of IAM role that allows your Amazon ECS container task to make calls to other AWS services.
 * @property volumes Configuration block for volumes that containers in your task may use. Detailed below.
 */
public data class TaskDefinitionArgs(
    public val containerDefinitions: Output<String>? = null,
    public val cpu: Output<String>? = null,
    public val ephemeralStorage: Output<TaskDefinitionEphemeralStorageArgs>? = null,
    public val executionRoleArn: Output<String>? = null,
    public val family: Output<String>? = null,
    public val inferenceAccelerators: Output<List<TaskDefinitionInferenceAcceleratorArgs>>? = null,
    public val ipcMode: Output<String>? = null,
    public val memory: Output<String>? = null,
    public val networkMode: Output<String>? = null,
    public val pidMode: Output<String>? = null,
    public val placementConstraints: Output<List<TaskDefinitionPlacementConstraintArgs>>? = null,
    public val proxyConfiguration: Output<TaskDefinitionProxyConfigurationArgs>? = null,
    public val requiresCompatibilities: Output<List<String>>? = null,
    public val runtimePlatform: Output<TaskDefinitionRuntimePlatformArgs>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskRoleArn: Output<String>? = null,
    public val volumes: Output<List<TaskDefinitionVolumeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.TaskDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.ecs.TaskDefinitionArgs =
        com.pulumi.aws.ecs.TaskDefinitionArgs.builder()
            .containerDefinitions(containerDefinitions?.applyValue({ args0 -> args0 }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .ephemeralStorage(ephemeralStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .executionRoleArn(executionRoleArn?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .inferenceAccelerators(
                inferenceAccelerators?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipcMode(ipcMode?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 }))
            .networkMode(networkMode?.applyValue({ args0 -> args0 }))
            .pidMode(pidMode?.applyValue({ args0 -> args0 }))
            .placementConstraints(
                placementConstraints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .proxyConfiguration(
                proxyConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requiresCompatibilities(
                requiresCompatibilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .runtimePlatform(runtimePlatform?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taskRoleArn(taskRoleArn?.applyValue({ args0 -> args0 }))
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TaskDefinitionArgs].
 */
@PulumiTagMarker
public class TaskDefinitionArgsBuilder internal constructor() {
    private var containerDefinitions: Output<String>? = null

    private var cpu: Output<String>? = null

    private var ephemeralStorage: Output<TaskDefinitionEphemeralStorageArgs>? = null

    private var executionRoleArn: Output<String>? = null

    private var family: Output<String>? = null

    private var inferenceAccelerators: Output<List<TaskDefinitionInferenceAcceleratorArgs>>? = null

    private var ipcMode: Output<String>? = null

    private var memory: Output<String>? = null

    private var networkMode: Output<String>? = null

    private var pidMode: Output<String>? = null

    private var placementConstraints: Output<List<TaskDefinitionPlacementConstraintArgs>>? = null

    private var proxyConfiguration: Output<TaskDefinitionProxyConfigurationArgs>? = null

    private var requiresCompatibilities: Output<List<String>>? = null

    private var runtimePlatform: Output<TaskDefinitionRuntimePlatformArgs>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskRoleArn: Output<String>? = null

    private var volumes: Output<List<TaskDefinitionVolumeArgs>>? = null

    /**
     * @param value A list of valid [container definitions](http://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/APIReference/API_ContainerDefinition&#46;html) provided as a single valid JSON document&#46; Please note that you should only provide values that are part of the container definition document&#46; For a detailed description of what parameters are available, see the [Task Definition Parameters](https://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/developerguide/task_definition_parameters&#46;html) section from the official [Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide).
     */
    @JvmName("jaejsekeubpurqej")
    public suspend fun containerDefinitions(`value`: Output<String>) {
        this.containerDefinitions = value
    }

    /**
     * @param value Number of cpu units used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
     */
    @JvmName("alcnyqockenbktae")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
     */
    @JvmName("djokwwidtkeytrea")
    public suspend fun ephemeralStorage(`value`: Output<TaskDefinitionEphemeralStorageArgs>) {
        this.ephemeralStorage = value
    }

    /**
     * @param value ARN of the task execution role that the Amazon ECS container agent and the Docker daemon can assume.
     */
    @JvmName("mhemdpjuebkhbhup")
    public suspend fun executionRoleArn(`value`: Output<String>) {
        this.executionRoleArn = value
    }

    /**
     * @param value A unique name for your task definition.
     * The following arguments are optional:
     */
    @JvmName("nqplqdujlgmdwnml")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value Configuration block(s) with Inference Accelerators settings. Detailed below.
     */
    @JvmName("gdlxfkdogwqlyelm")
    public suspend
    fun inferenceAccelerators(`value`: Output<List<TaskDefinitionInferenceAcceleratorArgs>>) {
        this.inferenceAccelerators = value
    }

    @JvmName("egkyfephqhphqyxp")
    public suspend fun inferenceAccelerators(
        vararg
        values: Output<TaskDefinitionInferenceAcceleratorArgs>,
    ) {
        this.inferenceAccelerators = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with Inference Accelerators settings. Detailed below.
     */
    @JvmName("rvmxicnoakynuxlo")
    public suspend
    fun inferenceAccelerators(values: List<Output<TaskDefinitionInferenceAcceleratorArgs>>) {
        this.inferenceAccelerators = Output.all(values)
    }

    /**
     * @param value IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
     */
    @JvmName("dnqvwqtqgqqtotvb")
    public suspend fun ipcMode(`value`: Output<String>) {
        this.ipcMode = value
    }

    /**
     * @param value Amount (in MiB) of memory used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
     */
    @JvmName("yjdiitnivdkxyhyg")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
     */
    @JvmName("dqsmahaunyonokow")
    public suspend fun networkMode(`value`: Output<String>) {
        this.networkMode = value
    }

    /**
     * @param value Process namespace to use for the containers in the task. The valid values are `host` and `task`.
     */
    @JvmName("mtflfalypqkbleah")
    public suspend fun pidMode(`value`: Output<String>) {
        this.pidMode = value
    }

    /**
     * @param value Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
     */
    @JvmName("hbdwfgxfaqpjeige")
    public suspend
    fun placementConstraints(`value`: Output<List<TaskDefinitionPlacementConstraintArgs>>) {
        this.placementConstraints = value
    }

    @JvmName("rytjcljtdlsyncll")
    public suspend fun placementConstraints(
        vararg
        values: Output<TaskDefinitionPlacementConstraintArgs>,
    ) {
        this.placementConstraints = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
     */
    @JvmName("lmbvqfgotubevaib")
    public suspend
    fun placementConstraints(values: List<Output<TaskDefinitionPlacementConstraintArgs>>) {
        this.placementConstraints = Output.all(values)
    }

    /**
     * @param value Configuration block for the App Mesh proxy. Detailed below.
     */
    @JvmName("aljyrxxycpbuinav")
    public suspend fun proxyConfiguration(`value`: Output<TaskDefinitionProxyConfigurationArgs>) {
        this.proxyConfiguration = value
    }

    /**
     * @param value Set of launch types required by the task. The valid values are `EC2` and `FARGATE`.
     */
    @JvmName("avnxamolhpwdvpah")
    public suspend fun requiresCompatibilities(`value`: Output<List<String>>) {
        this.requiresCompatibilities = value
    }

    @JvmName("rloonggnvwaidvcb")
    public suspend fun requiresCompatibilities(vararg values: Output<String>) {
        this.requiresCompatibilities = Output.all(values.asList())
    }

    /**
     * @param values Set of launch types required by the task. The valid values are `EC2` and `FARGATE`.
     */
    @JvmName("ipyaylmfyfluucsg")
    public suspend fun requiresCompatibilities(values: List<Output<String>>) {
        this.requiresCompatibilities = Output.all(values)
    }

    /**
     * @param value Configuration block for runtime_platform that containers in your task may use.
     */
    @JvmName("hghgbsaqxnonykuk")
    public suspend fun runtimePlatform(`value`: Output<TaskDefinitionRuntimePlatformArgs>) {
        this.runtimePlatform = value
    }

    /**
     * @param value Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
     */
    @JvmName("rmrwmcwugivdpbmy")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("slpdgqmeihwfbboh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARN of IAM role that allows your Amazon ECS container task to make calls to other AWS services.
     */
    @JvmName("qqkeijwlnmajfcqg")
    public suspend fun taskRoleArn(`value`: Output<String>) {
        this.taskRoleArn = value
    }

    /**
     * @param value Configuration block for volumes that containers in your task may use. Detailed below.
     */
    @JvmName("okuxccucmqlvpsjj")
    public suspend fun volumes(`value`: Output<List<TaskDefinitionVolumeArgs>>) {
        this.volumes = value
    }

    @JvmName("tdoheloraeexmtwu")
    public suspend fun volumes(vararg values: Output<TaskDefinitionVolumeArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for volumes that containers in your task may use. Detailed below.
     */
    @JvmName("adubiinsxcgigskp")
    public suspend fun volumes(values: List<Output<TaskDefinitionVolumeArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value A list of valid [container definitions](http://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/APIReference/API_ContainerDefinition&#46;html) provided as a single valid JSON document&#46; Please note that you should only provide values that are part of the container definition document&#46; For a detailed description of what parameters are available, see the [Task Definition Parameters](https://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/developerguide/task_definition_parameters&#46;html) section from the official [Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide).
     */
    @JvmName("yevdkhtukwxuecfx")
    public suspend fun containerDefinitions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerDefinitions = mapped
    }

    /**
     * @param value Number of cpu units used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
     */
    @JvmName("typoxfohdksruulw")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
     */
    @JvmName("xixkjoaergxajalu")
    public suspend fun ephemeralStorage(`value`: TaskDefinitionEphemeralStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralStorage = mapped
    }

    /**
     * @param argument The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
     */
    @JvmName("mtcxfjkmrpxnrvjw")
    public suspend
    fun ephemeralStorage(argument: suspend TaskDefinitionEphemeralStorageArgsBuilder.() -> Unit) {
        val toBeMapped = TaskDefinitionEphemeralStorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ephemeralStorage = mapped
    }

    /**
     * @param value ARN of the task execution role that the Amazon ECS container agent and the Docker daemon can assume.
     */
    @JvmName("pmmtxsrmrdydnqgh")
    public suspend fun executionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleArn = mapped
    }

    /**
     * @param value A unique name for your task definition.
     * The following arguments are optional:
     */
    @JvmName("hqajkmgjusgawtpk")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Configuration block(s) with Inference Accelerators settings. Detailed below.
     */
    @JvmName("qaijksbbudutqyph")
    public suspend fun inferenceAccelerators(`value`: List<TaskDefinitionInferenceAcceleratorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inferenceAccelerators = mapped
    }

    /**
     * @param argument Configuration block(s) with Inference Accelerators settings. Detailed below.
     */
    @JvmName("wumomrnvsylbupkm")
    public suspend
    fun inferenceAccelerators(argument: List<suspend TaskDefinitionInferenceAcceleratorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TaskDefinitionInferenceAcceleratorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inferenceAccelerators = mapped
    }

    /**
     * @param argument Configuration block(s) with Inference Accelerators settings. Detailed below.
     */
    @JvmName("hcnantejdqqtnira")
    public suspend fun inferenceAccelerators(
        vararg
        argument: suspend TaskDefinitionInferenceAcceleratorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TaskDefinitionInferenceAcceleratorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inferenceAccelerators = mapped
    }

    /**
     * @param argument Configuration block(s) with Inference Accelerators settings. Detailed below.
     */
    @JvmName("efemaoyywpxfwyiw")
    public suspend
    fun inferenceAccelerators(argument: suspend TaskDefinitionInferenceAcceleratorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TaskDefinitionInferenceAcceleratorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.inferenceAccelerators = mapped
    }

    /**
     * @param values Configuration block(s) with Inference Accelerators settings. Detailed below.
     */
    @JvmName("tqwrhcoyohflwcjl")
    public suspend fun inferenceAccelerators(vararg values: TaskDefinitionInferenceAcceleratorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inferenceAccelerators = mapped
    }

    /**
     * @param value IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
     */
    @JvmName("apqysklmrucosjvp")
    public suspend fun ipcMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipcMode = mapped
    }

    /**
     * @param value Amount (in MiB) of memory used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
     */
    @JvmName("eytpdfqmeqogxtta")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
     */
    @JvmName("jybyfjsolscokaas")
    public suspend fun networkMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkMode = mapped
    }

    /**
     * @param value Process namespace to use for the containers in the task. The valid values are `host` and `task`.
     */
    @JvmName("hxngpdkefngtfkgo")
    public suspend fun pidMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidMode = mapped
    }

    /**
     * @param value Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
     */
    @JvmName("njaaddwpbpasvolo")
    public suspend fun placementConstraints(`value`: List<TaskDefinitionPlacementConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param argument Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
     */
    @JvmName("cqxcnjsxngqymebt")
    public suspend
    fun placementConstraints(argument: List<suspend TaskDefinitionPlacementConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TaskDefinitionPlacementConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
     */
    @JvmName("kojcwhkjgbpjrchi")
    public suspend fun placementConstraints(
        vararg
        argument: suspend TaskDefinitionPlacementConstraintArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TaskDefinitionPlacementConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
     */
    @JvmName("jtcslmjduewnsmwu")
    public suspend
    fun placementConstraints(argument: suspend TaskDefinitionPlacementConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TaskDefinitionPlacementConstraintArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param values Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
     */
    @JvmName("ccjicpmvawyktpkh")
    public suspend fun placementConstraints(vararg values: TaskDefinitionPlacementConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param value Configuration block for the App Mesh proxy. Detailed below.
     */
    @JvmName("wciyelrnwalpcswy")
    public suspend fun proxyConfiguration(`value`: TaskDefinitionProxyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyConfiguration = mapped
    }

    /**
     * @param argument Configuration block for the App Mesh proxy. Detailed below.
     */
    @JvmName("gmoesfvpsbcnujpf")
    public suspend
    fun proxyConfiguration(argument: suspend TaskDefinitionProxyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TaskDefinitionProxyConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.proxyConfiguration = mapped
    }

    /**
     * @param value Set of launch types required by the task. The valid values are `EC2` and `FARGATE`.
     */
    @JvmName("svtgrmfqaqyfiinq")
    public suspend fun requiresCompatibilities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresCompatibilities = mapped
    }

    /**
     * @param values Set of launch types required by the task. The valid values are `EC2` and `FARGATE`.
     */
    @JvmName("iyasolrsbsjrnrbd")
    public suspend fun requiresCompatibilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiresCompatibilities = mapped
    }

    /**
     * @param value Configuration block for runtime_platform that containers in your task may use.
     */
    @JvmName("icwkipnevijfqxuv")
    public suspend fun runtimePlatform(`value`: TaskDefinitionRuntimePlatformArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimePlatform = mapped
    }

    /**
     * @param argument Configuration block for runtime_platform that containers in your task may use.
     */
    @JvmName("tojpfavoppmqvdbs")
    public suspend
    fun runtimePlatform(argument: suspend TaskDefinitionRuntimePlatformArgsBuilder.() -> Unit) {
        val toBeMapped = TaskDefinitionRuntimePlatformArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runtimePlatform = mapped
    }

    /**
     * @param value Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
     */
    @JvmName("ppexrlivvjfibcds")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cibndnmogeknlsmr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fxldfwmrivhmakxk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ARN of IAM role that allows your Amazon ECS container task to make calls to other AWS services.
     */
    @JvmName("lvhhsgukgmkgkcyk")
    public suspend fun taskRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskRoleArn = mapped
    }

    /**
     * @param value Configuration block for volumes that containers in your task may use. Detailed below.
     */
    @JvmName("vsybwxklawpsvbxy")
    public suspend fun volumes(`value`: List<TaskDefinitionVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument Configuration block for volumes that containers in your task may use. Detailed below.
     */
    @JvmName("uqmkkixeixyuskix")
    public suspend fun volumes(argument: List<suspend TaskDefinitionVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TaskDefinitionVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument Configuration block for volumes that containers in your task may use. Detailed below.
     */
    @JvmName("xrehoxrhsqutiame")
    public suspend fun volumes(vararg argument: suspend TaskDefinitionVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TaskDefinitionVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument Configuration block for volumes that containers in your task may use. Detailed below.
     */
    @JvmName("pypxmikumwfuspuy")
    public suspend fun volumes(argument: suspend TaskDefinitionVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TaskDefinitionVolumeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values Configuration block for volumes that containers in your task may use. Detailed below.
     */
    @JvmName("mhwtdjcqolagixau")
    public suspend fun volumes(vararg values: TaskDefinitionVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    internal fun build(): TaskDefinitionArgs = TaskDefinitionArgs(
        containerDefinitions = containerDefinitions,
        cpu = cpu,
        ephemeralStorage = ephemeralStorage,
        executionRoleArn = executionRoleArn,
        family = family,
        inferenceAccelerators = inferenceAccelerators,
        ipcMode = ipcMode,
        memory = memory,
        networkMode = networkMode,
        pidMode = pidMode,
        placementConstraints = placementConstraints,
        proxyConfiguration = proxyConfiguration,
        requiresCompatibilities = requiresCompatibilities,
        runtimePlatform = runtimePlatform,
        skipDestroy = skipDestroy,
        tags = tags,
        taskRoleArn = taskRoleArn,
        volumes = volumes,
    )
}
