@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.kotlin.outputs.TaskSetCapacityProviderStrategy
import com.pulumi.aws.ecs.kotlin.outputs.TaskSetLoadBalancer
import com.pulumi.aws.ecs.kotlin.outputs.TaskSetNetworkConfiguration
import com.pulumi.aws.ecs.kotlin.outputs.TaskSetScale
import com.pulumi.aws.ecs.kotlin.outputs.TaskSetServiceRegistries
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ecs.kotlin.outputs.TaskSetCapacityProviderStrategy.Companion.toKotlin as taskSetCapacityProviderStrategyToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskSetLoadBalancer.Companion.toKotlin as taskSetLoadBalancerToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskSetNetworkConfiguration.Companion.toKotlin as taskSetNetworkConfigurationToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskSetScale.Companion.toKotlin as taskSetScaleToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskSetServiceRegistries.Companion.toKotlin as taskSetServiceRegistriesToKotlin

/**
 * Builder for [TaskSet].
 */
@PulumiTagMarker
public class TaskSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TaskSetArgs = TaskSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TaskSetArgsBuilder.() -> Unit) {
        val builder = TaskSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TaskSet {
        val builtJavaResource = com.pulumi.aws.ecs.TaskSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TaskSet(builtJavaResource)
    }
}

/**
 * Provides an ECS task set - effectively a task that is expected to run until an error occurs or a user terminates it (typically a webserver or a database).
 * See [ECS Task Set section in AWS developer guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-external.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskSet;
 * import com.pulumi.aws.ecs.TaskSetArgs;
 * import com.pulumi.aws.ecs.inputs.TaskSetLoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TaskSet("example", TaskSetArgs.builder()
 *             .service(aws_ecs_service.example().id())
 *             .cluster(aws_ecs_cluster.example().id())
 *             .taskDefinition(aws_ecs_task_definition.example().arn())
 *             .loadBalancers(TaskSetLoadBalancerArgs.builder()
 *                 .targetGroupArn(aws_lb_target_group.example().arn())
 *                 .containerName("mongo")
 *                 .containerPort(8080)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Ignoring Changes to Scale
 * You can utilize the generic resource lifecycle configuration block with `ignore_changes` to create an ECS service with an initial count of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskSet;
 * import com.pulumi.aws.ecs.TaskSetArgs;
 * import com.pulumi.aws.ecs.inputs.TaskSetScaleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TaskSet("example", TaskSetArgs.builder()
 *             .lifecycle(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .scale(TaskSetScaleArgs.builder()
 *                 .value(50)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECS Task Sets using the `task_set_id`, `service`, and `cluster` separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ecs/taskSet:TaskSet example ecs-svc/7177320696926227436,arn:aws:ecs:us-west-2:123456789101:service/example/example-1234567890,arn:aws:ecs:us-west-2:123456789101:cluster/example
 * ```
 *
 */
public class TaskSet internal constructor(
    override val javaResource: com.pulumi.aws.ecs.TaskSet,
) : KotlinCustomResource(javaResource, TaskSetMapper) {
    /**
     * The Amazon Resource Name (ARN) that identifies the task set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     */
    public val capacityProviderStrategies: Output<List<TaskSetCapacityProviderStrategy>>?
        get() = javaResource.capacityProviderStrategies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        taskSetCapacityProviderStrategyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The short name or ARN of the cluster that hosts the service to create the task set in.
     */
    public val cluster: Output<String>
        get() = javaResource.cluster().applyValue({ args0 -> args0 })

    /**
     * The external ID associated with the task set.
     */
    public val externalId: Output<String>
        get() = javaResource.externalId().applyValue({ args0 -> args0 })

    /**
     * Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
     */
    public val launchType: Output<String>
        get() = javaResource.launchType().applyValue({ args0 -> args0 })

    /**
     * Details on load balancers that are used with a task set. Detailed below.
     */
    public val loadBalancers: Output<List<TaskSetLoadBalancer>>?
        get() = javaResource.loadBalancers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        taskSetLoadBalancerToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
     */
    public val networkConfiguration: Output<TaskSetNetworkConfiguration>?
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> taskSetNetworkConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    public val platformVersion: Output<String>
        get() = javaResource.platformVersion().applyValue({ args0 -> args0 })

    /**
     * A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
     */
    public val scale: Output<TaskSetScale>
        get() = javaResource.scale().applyValue({ args0 ->
            args0.let({ args0 ->
                taskSetScaleToKotlin(args0)
            })
        })

    /**
     * The short name or ARN of the ECS service.
     */
    public val service: Output<String>
        get() = javaResource.service().applyValue({ args0 -> args0 })

    /**
     * The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
     */
    public val serviceRegistries: Output<TaskSetServiceRegistries>?
        get() = javaResource.serviceRegistries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> taskSetServiceRegistriesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The stability status. This indicates whether the task set has reached a steady state.
     */
    public val stabilityStatus: Output<String>
        get() = javaResource.stabilityStatus().applyValue({ args0 -> args0 })

    /**
     * The status of the task set.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
     * The following arguments are optional:
     */
    public val taskDefinition: Output<String>
        get() = javaResource.taskDefinition().applyValue({ args0 -> args0 })

    /**
     * The ID of the task set.
     */
    public val taskSetId: Output<String>
        get() = javaResource.taskSetId().applyValue({ args0 -> args0 })

    /**
     * Whether the provider should wait until the task set has reached `STEADY_STATE`.
     */
    public val waitUntilStable: Output<Boolean>?
        get() = javaResource.waitUntilStable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
     */
    public val waitUntilStableTimeout: Output<String>?
        get() = javaResource.waitUntilStableTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TaskSetMapper : ResourceMapper<TaskSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecs.TaskSet::class == javaResource::class

    override fun map(javaResource: Resource): TaskSet = TaskSet(
        javaResource as
            com.pulumi.aws.ecs.TaskSet,
    )
}

/**
 * @see [TaskSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TaskSet].
 */
public suspend fun taskSet(name: String, block: suspend TaskSetResourceBuilder.() -> Unit):
    TaskSet {
    val builder = TaskSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TaskSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun taskSet(name: String): TaskSet {
    val builder = TaskSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
