@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoScalingGroupArn ARN of the associated auto scaling group.
 * @property managedScaling Configuration block defining the parameters of the auto scaling. Detailed below.
 * @property managedTerminationProtection Enables or disables container-aware termination of instances in the auto scaling group when scale-in happens. Valid values are `ENABLED` and `DISABLED`.
 */
public data class CapacityProviderAutoScalingGroupProviderArgs(
    public val autoScalingGroupArn: Output<String>,
    public val managedScaling: Output<CapacityProviderAutoScalingGroupProviderManagedScalingArgs>? =
        null,
    public val managedTerminationProtection: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderArgs =
        com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderArgs.builder()
            .autoScalingGroupArn(autoScalingGroupArn.applyValue({ args0 -> args0 }))
            .managedScaling(managedScaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managedTerminationProtection(managedTerminationProtection?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CapacityProviderAutoScalingGroupProviderArgs].
 */
@PulumiTagMarker
public class CapacityProviderAutoScalingGroupProviderArgsBuilder internal constructor() {
    private var autoScalingGroupArn: Output<String>? = null

    private var managedScaling: Output<CapacityProviderAutoScalingGroupProviderManagedScalingArgs>? =
        null

    private var managedTerminationProtection: Output<String>? = null

    /**
     * @param value ARN of the associated auto scaling group.
     */
    @JvmName("hfnidkugemqhshmx")
    public suspend fun autoScalingGroupArn(`value`: Output<String>) {
        this.autoScalingGroupArn = value
    }

    /**
     * @param value Configuration block defining the parameters of the auto scaling. Detailed below.
     */
    @JvmName("qeajubhpuuduqjtr")
    public suspend
    fun managedScaling(`value`: Output<CapacityProviderAutoScalingGroupProviderManagedScalingArgs>) {
        this.managedScaling = value
    }

    /**
     * @param value Enables or disables container-aware termination of instances in the auto scaling group when scale-in happens. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("hhjyisobrhttwqeg")
    public suspend fun managedTerminationProtection(`value`: Output<String>) {
        this.managedTerminationProtection = value
    }

    /**
     * @param value ARN of the associated auto scaling group.
     */
    @JvmName("qhxpswdsuqbutfhq")
    public suspend fun autoScalingGroupArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoScalingGroupArn = mapped
    }

    /**
     * @param value Configuration block defining the parameters of the auto scaling. Detailed below.
     */
    @JvmName("hwfqacwavinxbcov")
    public suspend
    fun managedScaling(`value`: CapacityProviderAutoScalingGroupProviderManagedScalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedScaling = mapped
    }

    /**
     * @param argument Configuration block defining the parameters of the auto scaling. Detailed below.
     */
    @JvmName("rnrxwqjrwwpyddmc")
    public suspend
    fun managedScaling(argument: suspend CapacityProviderAutoScalingGroupProviderManagedScalingArgsBuilder.() -> Unit) {
        val toBeMapped =
            CapacityProviderAutoScalingGroupProviderManagedScalingArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.managedScaling = mapped
    }

    /**
     * @param value Enables or disables container-aware termination of instances in the auto scaling group when scale-in happens. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("psktyhpxptoawkgs")
    public suspend fun managedTerminationProtection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedTerminationProtection = mapped
    }

    internal fun build(): CapacityProviderAutoScalingGroupProviderArgs =
        CapacityProviderAutoScalingGroupProviderArgs(
            autoScalingGroupArn = autoScalingGroupArn ?: throw PulumiNullFieldException("autoScalingGroupArn"),
            managedScaling = managedScaling,
            managedTerminationProtection = managedTerminationProtection,
        )
}
