@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property executeCommandConfiguration The details of the execute command configuration. Detailed below.
 */
public data class ClusterConfigurationArgs(
    public val executeCommandConfiguration:
    Output<ClusterConfigurationExecuteCommandConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs =
        com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs.builder()
            .executeCommandConfiguration(
                executeCommandConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterConfigurationArgsBuilder internal constructor() {
    private var executeCommandConfiguration:
        Output<ClusterConfigurationExecuteCommandConfigurationArgs>? = null

    /**
     * @param value The details of the execute command configuration. Detailed below.
     */
    @JvmName("ogymrbdcqqwurano")
    public suspend
    fun executeCommandConfiguration(`value`: Output<ClusterConfigurationExecuteCommandConfigurationArgs>) {
        this.executeCommandConfiguration = value
    }

    /**
     * @param value The details of the execute command configuration. Detailed below.
     */
    @JvmName("qpechiadgerwvsik")
    public suspend
    fun executeCommandConfiguration(`value`: ClusterConfigurationExecuteCommandConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executeCommandConfiguration = mapped
    }

    /**
     * @param argument The details of the execute command configuration. Detailed below.
     */
    @JvmName("kxbawtwdgqyakwcg")
    public suspend
    fun executeCommandConfiguration(argument: suspend ClusterConfigurationExecuteCommandConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterConfigurationExecuteCommandConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.executeCommandConfiguration = mapped
    }

    internal fun build(): ClusterConfigurationArgs = ClusterConfigurationArgs(
        executeCommandConfiguration = executeCommandConfiguration,
    )
}
