@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudWatchEncryptionEnabled Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
 * @property cloudWatchLogGroupName The name of the CloudWatch log group to send logs to.
 * @property s3BucketEncryptionEnabled Whether or not to enable encryption on the logs sent to S3. If not specified, encryption will be disabled.
 * @property s3BucketName The name of the S3 bucket to send logs to.
 * @property s3KeyPrefix An optional folder in the S3 bucket to place logs in.
 */
public data class ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs(
    public val cloudWatchEncryptionEnabled: Output<Boolean>? = null,
    public val cloudWatchLogGroupName: Output<String>? = null,
    public val s3BucketEncryptionEnabled: Output<Boolean>? = null,
    public val s3BucketName: Output<String>? = null,
    public val s3KeyPrefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs =
        com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs.builder()
            .cloudWatchEncryptionEnabled(cloudWatchEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .cloudWatchLogGroupName(cloudWatchLogGroupName?.applyValue({ args0 -> args0 }))
            .s3BucketEncryptionEnabled(s3BucketEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .s3BucketName(s3BucketName?.applyValue({ args0 -> args0 }))
            .s3KeyPrefix(s3KeyPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgsBuilder internal
constructor() {
    private var cloudWatchEncryptionEnabled: Output<Boolean>? = null

    private var cloudWatchLogGroupName: Output<String>? = null

    private var s3BucketEncryptionEnabled: Output<Boolean>? = null

    private var s3BucketName: Output<String>? = null

    private var s3KeyPrefix: Output<String>? = null

    /**
     * @param value Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
     */
    @JvmName("lrgmyeievhpwixen")
    public suspend fun cloudWatchEncryptionEnabled(`value`: Output<Boolean>) {
        this.cloudWatchEncryptionEnabled = value
    }

    /**
     * @param value The name of the CloudWatch log group to send logs to.
     */
    @JvmName("xshyfvmwqfiysblw")
    public suspend fun cloudWatchLogGroupName(`value`: Output<String>) {
        this.cloudWatchLogGroupName = value
    }

    /**
     * @param value Whether or not to enable encryption on the logs sent to S3. If not specified, encryption will be disabled.
     */
    @JvmName("twdtysyofnagomog")
    public suspend fun s3BucketEncryptionEnabled(`value`: Output<Boolean>) {
        this.s3BucketEncryptionEnabled = value
    }

    /**
     * @param value The name of the S3 bucket to send logs to.
     */
    @JvmName("mortarvykdocypfx")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value An optional folder in the S3 bucket to place logs in.
     */
    @JvmName("nsjsjqgoxqlkmtuo")
    public suspend fun s3KeyPrefix(`value`: Output<String>) {
        this.s3KeyPrefix = value
    }

    /**
     * @param value Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
     */
    @JvmName("yxghlgqwvyfmbrrb")
    public suspend fun cloudWatchEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudWatchEncryptionEnabled = mapped
    }

    /**
     * @param value The name of the CloudWatch log group to send logs to.
     */
    @JvmName("yegkfwmckjcwbtdi")
    public suspend fun cloudWatchLogGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudWatchLogGroupName = mapped
    }

    /**
     * @param value Whether or not to enable encryption on the logs sent to S3. If not specified, encryption will be disabled.
     */
    @JvmName("gitpvnvtasugyomr")
    public suspend fun s3BucketEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketEncryptionEnabled = mapped
    }

    /**
     * @param value The name of the S3 bucket to send logs to.
     */
    @JvmName("fruwiaymggejubed")
    public suspend fun s3BucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value An optional folder in the S3 bucket to place logs in.
     */
    @JvmName("wvdukyojkellxgil")
    public suspend fun s3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KeyPrefix = mapped
    }

    internal fun build(): ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs =
        ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs(
            cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled,
            cloudWatchLogGroupName = cloudWatchLogGroupName,
            s3BucketEncryptionEnabled = s3BucketEncryptionEnabled,
            s3BucketName = s3BucketName,
            s3KeyPrefix = s3KeyPrefix,
        )
}
