@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ClusterServiceConnectDefaultsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespace The ARN of the `aws.servicediscovery.HttpNamespace` that's used when you create a service and don't specify a Service Connect configuration.
 */
public data class ClusterServiceConnectDefaultsArgs(
    public val namespace: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ClusterServiceConnectDefaultsArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ClusterServiceConnectDefaultsArgs =
        com.pulumi.aws.ecs.inputs.ClusterServiceConnectDefaultsArgs.builder()
            .namespace(namespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterServiceConnectDefaultsArgs].
 */
@PulumiTagMarker
public class ClusterServiceConnectDefaultsArgsBuilder internal constructor() {
    private var namespace: Output<String>? = null

    /**
     * @param value The ARN of the `aws.servicediscovery.HttpNamespace` that's used when you create a service and don't specify a Service Connect configuration.
     */
    @JvmName("mxajvhfvdgjfsjob")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The ARN of the `aws.servicediscovery.HttpNamespace` that's used when you create a service and don't specify a Service Connect configuration.
     */
    @JvmName("crwuyvsknjispvsd")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): ClusterServiceConnectDefaultsArgs = ClusterServiceConnectDefaultsArgs(
        namespace = namespace ?: throw PulumiNullFieldException("namespace"),
    )
}
