@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ClusterSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the setting to manage. Valid values: `containerInsights`.
 * @property value The value to assign to the setting. Valid values are `enabled` and `disabled`.
 */
public data class ClusterSettingArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ClusterSettingArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ClusterSettingArgs =
        com.pulumi.aws.ecs.inputs.ClusterSettingArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterSettingArgs].
 */
@PulumiTagMarker
public class ClusterSettingArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the setting to manage. Valid values: `containerInsights`.
     */
    @JvmName("xicoyvayuyvocwkr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value to assign to the setting. Valid values are `enabled` and `disabled`.
     */
    @JvmName("rjvcpkovpfdxnqwg")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the setting to manage. Valid values: `containerInsights`.
     */
    @JvmName("quhdnasibdrvyykr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value to assign to the setting. Valid values are `enabled` and `disabled`.
     */
    @JvmName("rsseejbkrihnjahe")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ClusterSettingArgs = ClusterSettingArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
