@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getService.
 * @property clusterArn ARN of the ECS Cluster
 * @property serviceName Name of the ECS Service
 * @property tags Resource tags.
 */
public data class GetServicePlainArgs(
    public val clusterArn: String,
    public val serviceName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetServicePlainArgs =
        com.pulumi.aws.ecs.inputs.GetServicePlainArgs.builder()
            .clusterArn(clusterArn.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var clusterArn: String? = null

    private var serviceName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the ECS Cluster
     */
    @JvmName("bdbhfajjulbmedbm")
    public suspend fun clusterArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterArn = mapped
    }

    /**
     * @param value Name of the ECS Service
     */
    @JvmName("ihsvaocmixbqmsbs")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lnhxnocraovqrsgx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ylmacoagkfjyeiqr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        clusterArn = clusterArn ?: throw PulumiNullFieldException("clusterArn"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        tags = tags,
    )
}
