@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskExecutionNetworkConfiguration.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property assignPublicIp Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.
 * For more information, see the [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) documentation.
 * @property securityGroups Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
 * @property subnets Subnets associated with the task or service.
 */
public data class GetTaskExecutionNetworkConfiguration(
    public val assignPublicIp: Boolean? = null,
    public val securityGroups: List<String>? = null,
    public val subnets: List<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskExecutionNetworkConfiguration> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetTaskExecutionNetworkConfiguration =
        com.pulumi.aws.ecs.inputs.GetTaskExecutionNetworkConfiguration.builder()
            .assignPublicIp(assignPublicIp?.let({ args0 -> args0 }))
            .securityGroups(securityGroups?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetTaskExecutionNetworkConfiguration].
 */
@PulumiTagMarker
public class GetTaskExecutionNetworkConfigurationBuilder internal constructor() {
    private var assignPublicIp: Boolean? = null

    private var securityGroups: List<String>? = null

    private var subnets: List<String>? = null

    /**
     * @param value Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.
     * For more information, see the [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) documentation.
     */
    @JvmName("pdtxvlcobjypwlwc")
    public suspend fun assignPublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.assignPublicIp = mapped
    }

    /**
     * @param value Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("vodxnasaeketkhnc")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityGroups = mapped
    }

    /**
     * @param values Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("uvpcnuhyvmuryvjp")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityGroups = mapped
    }

    /**
     * @param value Subnets associated with the task or service.
     */
    @JvmName("tmyovsicfrlfocrr")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subnets = mapped
    }

    /**
     * @param values Subnets associated with the task or service.
     */
    @JvmName("oxrgwbbfrrmfmjoi")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subnets = mapped
    }

    internal fun build(): GetTaskExecutionNetworkConfiguration = GetTaskExecutionNetworkConfiguration(
        assignPublicIp = assignPublicIp,
        securityGroups = securityGroups,
        subnets = subnets ?: throw PulumiNullFieldException("subnets"),
    )
}
