@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskExecutionOverrides.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property containerOverrides One or more container overrides that are sent to a task. See below.
 * @property cpu The CPU override for the task.
 * @property executionRoleArn Amazon Resource Name (ARN) of the task execution role override for the task.
 * @property inferenceAcceleratorOverrides Elastic Inference accelerator override for the task. See below.
 * @property memory The memory override for the task.
 * @property taskRoleArn Amazon Resource Name (ARN) of the role that containers in this task can assume.
 */
public data class GetTaskExecutionOverrides(
    public val containerOverrides: List<GetTaskExecutionOverridesContainerOverride>? = null,
    public val cpu: String? = null,
    public val executionRoleArn: String? = null,
    public val inferenceAcceleratorOverrides:
    List<GetTaskExecutionOverridesInferenceAcceleratorOverride>? = null,
    public val memory: String? = null,
    public val taskRoleArn: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskExecutionOverrides> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetTaskExecutionOverrides =
        com.pulumi.aws.ecs.inputs.GetTaskExecutionOverrides.builder()
            .containerOverrides(
                containerOverrides?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cpu(cpu?.let({ args0 -> args0 }))
            .executionRoleArn(executionRoleArn?.let({ args0 -> args0 }))
            .inferenceAcceleratorOverrides(
                inferenceAcceleratorOverrides?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .memory(memory?.let({ args0 -> args0 }))
            .taskRoleArn(taskRoleArn?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskExecutionOverrides].
 */
@PulumiTagMarker
public class GetTaskExecutionOverridesBuilder internal constructor() {
    private var containerOverrides: List<GetTaskExecutionOverridesContainerOverride>? = null

    private var cpu: String? = null

    private var executionRoleArn: String? = null

    private var inferenceAcceleratorOverrides:
        List<GetTaskExecutionOverridesInferenceAcceleratorOverride>? = null

    private var memory: String? = null

    private var taskRoleArn: String? = null

    /**
     * @param value One or more container overrides that are sent to a task. See below.
     */
    @JvmName("pnvrxtpqduihgxqb")
    public suspend
    fun containerOverrides(`value`: List<GetTaskExecutionOverridesContainerOverride>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.containerOverrides = mapped
    }

    /**
     * @param argument One or more container overrides that are sent to a task. See below.
     */
    @JvmName("offdbokxowadocyj")
    public suspend
    fun containerOverrides(argument: List<suspend GetTaskExecutionOverridesContainerOverrideBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionOverridesContainerOverrideBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.containerOverrides = mapped
    }

    /**
     * @param argument One or more container overrides that are sent to a task. See below.
     */
    @JvmName("moafvqrwnhcdefbf")
    public suspend fun containerOverrides(
        vararg
        argument: suspend GetTaskExecutionOverridesContainerOverrideBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionOverridesContainerOverrideBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.containerOverrides = mapped
    }

    /**
     * @param argument One or more container overrides that are sent to a task. See below.
     */
    @JvmName("crsduwrfrvpkryus")
    public suspend
    fun containerOverrides(argument: suspend GetTaskExecutionOverridesContainerOverrideBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTaskExecutionOverridesContainerOverrideBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.containerOverrides = mapped
    }

    /**
     * @param values One or more container overrides that are sent to a task. See below.
     */
    @JvmName("joalbcnpqosrxfja")
    public suspend fun containerOverrides(vararg values: GetTaskExecutionOverridesContainerOverride) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerOverrides = mapped
    }

    /**
     * @param value The CPU override for the task.
     */
    @JvmName("wjpaqmefhpxliamy")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cpu = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the task execution role override for the task.
     */
    @JvmName("cfntfbuxyhinetwc")
    public suspend fun executionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.executionRoleArn = mapped
    }

    /**
     * @param value Elastic Inference accelerator override for the task. See below.
     */
    @JvmName("mvkktrdivvhwsdvl")
    public suspend
    fun inferenceAcceleratorOverrides(`value`: List<GetTaskExecutionOverridesInferenceAcceleratorOverride>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param argument Elastic Inference accelerator override for the task. See below.
     */
    @JvmName("twtgdtbwrmdyibac")
    public suspend
    fun inferenceAcceleratorOverrides(argument: List<suspend GetTaskExecutionOverridesInferenceAcceleratorOverrideBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionOverridesInferenceAcceleratorOverrideBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param argument Elastic Inference accelerator override for the task. See below.
     */
    @JvmName("hmrrjtpuaewhqfbr")
    public suspend fun inferenceAcceleratorOverrides(
        vararg
        argument: suspend GetTaskExecutionOverridesInferenceAcceleratorOverrideBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionOverridesInferenceAcceleratorOverrideBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param argument Elastic Inference accelerator override for the task. See below.
     */
    @JvmName("bjybbqkjlvshyqoa")
    public suspend
    fun inferenceAcceleratorOverrides(argument: suspend GetTaskExecutionOverridesInferenceAcceleratorOverrideBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetTaskExecutionOverridesInferenceAcceleratorOverrideBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = toBeMapped
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param values Elastic Inference accelerator override for the task. See below.
     */
    @JvmName("xvyrtolurhlovubm")
    public suspend fun inferenceAcceleratorOverrides(
        vararg
        values: GetTaskExecutionOverridesInferenceAcceleratorOverride,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param value The memory override for the task.
     */
    @JvmName("stkvqesrhrjubmxi")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.memory = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the role that containers in this task can assume.
     */
    @JvmName("nylsjrgpbutwdoip")
    public suspend fun taskRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.taskRoleArn = mapped
    }

    internal fun build(): GetTaskExecutionOverrides = GetTaskExecutionOverrides(
        containerOverrides = containerOverrides,
        cpu = cpu,
        executionRoleArn = executionRoleArn,
        inferenceAcceleratorOverrides = inferenceAcceleratorOverrides,
        memory = memory,
        taskRoleArn = taskRoleArn,
    )
}
