@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesContainerOverrideEnvironment.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The name of the key-value pair. For environment variables, this is the name of the environment variable.
 * @property value The value of the key-value pair. For environment variables, this is the value of the environment variable.
 */
public data class GetTaskExecutionOverridesContainerOverrideEnvironment(
    public val key: String,
    public val `value`: String,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesContainerOverrideEnvironment> {
    override fun toJava():
        com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesContainerOverrideEnvironment =
        com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesContainerOverrideEnvironment.builder()
            .key(key.let({ args0 -> args0 }))
            .`value`(`value`.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskExecutionOverridesContainerOverrideEnvironment].
 */
@PulumiTagMarker
public class GetTaskExecutionOverridesContainerOverrideEnvironmentBuilder internal constructor() {
    private var key: String? = null

    private var `value`: String? = null

    /**
     * @param value The name of the key-value pair. For environment variables, this is the name of the environment variable.
     */
    @JvmName("olfpicprcnprlidb")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value The value of the key-value pair. For environment variables, this is the value of the environment variable.
     */
    @JvmName("jblbdnnwxwvdbvih")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.`value` = mapped
    }

    internal fun build(): GetTaskExecutionOverridesContainerOverrideEnvironment =
        GetTaskExecutionOverridesContainerOverrideEnvironment(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
