@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesContainerOverrideResourceRequirement.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of resource to assign to a container. Valid values are `GPU` or `InferenceAccelerator`.
 * @property value The value for the specified resource type. If the `GPU` type is used, the value is the number of physical GPUs the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on. If the `InferenceAccelerator` type is used, the value matches the `deviceName` for an InferenceAccelerator specified in a task definition.
 */
public data class GetTaskExecutionOverridesContainerOverrideResourceRequirement(
    public val type: String,
    public val `value`: String,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesContainerOverrideResourceRequirement> {
    override fun toJava():
        com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesContainerOverrideResourceRequirement =
        com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesContainerOverrideResourceRequirement.builder()
            .type(type.let({ args0 -> args0 }))
            .`value`(`value`.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskExecutionOverridesContainerOverrideResourceRequirement].
 */
@PulumiTagMarker
public class GetTaskExecutionOverridesContainerOverrideResourceRequirementBuilder internal
constructor() {
    private var type: String? = null

    private var `value`: String? = null

    /**
     * @param value The type of resource to assign to a container. Valid values are `GPU` or `InferenceAccelerator`.
     */
    @JvmName("gtekiifccveykltx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value The value for the specified resource type. If the `GPU` type is used, the value is the number of physical GPUs the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on. If the `InferenceAccelerator` type is used, the value matches the `deviceName` for an InferenceAccelerator specified in a task definition.
     */
    @JvmName("gefkucwopuvskflo")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.`value` = mapped
    }

    internal fun build(): GetTaskExecutionOverridesContainerOverrideResourceRequirement =
        GetTaskExecutionOverridesContainerOverrideResourceRequirement(
            type = type ?: throw PulumiNullFieldException("type"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
