@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskExecutionPlacementStrategy.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property field The field to apply the placement strategy against.
 * @property type The type of placement strategy. Valid values are `random`, `spread`, and `binpack`.
 * For more information, see the [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html) documentation.
 */
public data class GetTaskExecutionPlacementStrategy(
    public val `field`: String? = null,
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskExecutionPlacementStrategy> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetTaskExecutionPlacementStrategy =
        com.pulumi.aws.ecs.inputs.GetTaskExecutionPlacementStrategy.builder()
            .`field`(`field`?.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskExecutionPlacementStrategy].
 */
@PulumiTagMarker
public class GetTaskExecutionPlacementStrategyBuilder internal constructor() {
    private var `field`: String? = null

    private var type: String? = null

    /**
     * @param value The field to apply the placement strategy against.
     */
    @JvmName("xqeftvaijlotcbsv")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.`field` = mapped
    }

    /**
     * @param value The type of placement strategy. Valid values are `random`, `spread`, and `binpack`.
     * For more information, see the [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html) documentation.
     */
    @JvmName("pexcoipupshkfsju")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetTaskExecutionPlacementStrategy = GetTaskExecutionPlacementStrategy(
        `field` = `field`,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
