@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskExecutionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTaskExecution.
 * @property capacityProviderStrategies Set of capacity provider strategies to use for the cluster. See below.
 * @property cluster Short name or full Amazon Resource Name (ARN) of the cluster to run the task on.
 * @property desiredCount Number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.
 * @property enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
 * @property enableExecuteCommand Specifies whether to enable Amazon ECS Exec for the tasks within the service.
 * @property group Name of the task group to associate with the task. The default value is the family name of the task definition.
 * @property launchType Launch type on which to run your service. Valid values are `EC2`, `FARGATE`, and `EXTERNAL`.
 * @property networkConfiguration Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
 * @property overrides A list of container overrides that specify the name of a container in the specified task definition and the overrides it should receive.
 * @property placementConstraints An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
 * @property placementStrategies The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
 * @property platformVersion The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the `LATEST` platform version is used.
 * @property propagateTags Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. An error will be received if you specify the `SERVICE` option when running a task. Valid values are `TASK_DEFINITION` or `NONE`.
 * @property referenceId The reference ID to use for the task.
 * @property startedBy An optional tag specified when a task is started.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property taskDefinition The `family` and `revision` (`family:revision`) or full ARN of the task definition to run. If a revision isn't specified, the latest `ACTIVE` revision is used.
 * The following arguments are optional:
 */
public data class GetTaskExecutionPlainArgs(
    public val capacityProviderStrategies: List<GetTaskExecutionCapacityProviderStrategy>? = null,
    public val cluster: String,
    public val desiredCount: Int? = null,
    public val enableEcsManagedTags: Boolean? = null,
    public val enableExecuteCommand: Boolean? = null,
    public val group: String? = null,
    public val launchType: String? = null,
    public val networkConfiguration: GetTaskExecutionNetworkConfiguration? = null,
    public val overrides: GetTaskExecutionOverrides? = null,
    public val placementConstraints: List<GetTaskExecutionPlacementConstraint>? = null,
    public val placementStrategies: List<GetTaskExecutionPlacementStrategy>? = null,
    public val platformVersion: String? = null,
    public val propagateTags: String? = null,
    public val referenceId: String? = null,
    public val startedBy: String? = null,
    public val tags: Map<String, String>? = null,
    public val taskDefinition: String,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskExecutionPlainArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetTaskExecutionPlainArgs =
        com.pulumi.aws.ecs.inputs.GetTaskExecutionPlainArgs.builder()
            .capacityProviderStrategies(
                capacityProviderStrategies?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cluster(cluster.let({ args0 -> args0 }))
            .desiredCount(desiredCount?.let({ args0 -> args0 }))
            .enableEcsManagedTags(enableEcsManagedTags?.let({ args0 -> args0 }))
            .enableExecuteCommand(enableExecuteCommand?.let({ args0 -> args0 }))
            .group(group?.let({ args0 -> args0 }))
            .launchType(launchType?.let({ args0 -> args0 }))
            .networkConfiguration(networkConfiguration?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .overrides(overrides?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .placementConstraints(
                placementConstraints?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .placementStrategies(
                placementStrategies?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .platformVersion(platformVersion?.let({ args0 -> args0 }))
            .propagateTags(propagateTags?.let({ args0 -> args0 }))
            .referenceId(referenceId?.let({ args0 -> args0 }))
            .startedBy(startedBy?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taskDefinition(taskDefinition.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskExecutionPlainArgs].
 */
@PulumiTagMarker
public class GetTaskExecutionPlainArgsBuilder internal constructor() {
    private var capacityProviderStrategies: List<GetTaskExecutionCapacityProviderStrategy>? = null

    private var cluster: String? = null

    private var desiredCount: Int? = null

    private var enableEcsManagedTags: Boolean? = null

    private var enableExecuteCommand: Boolean? = null

    private var group: String? = null

    private var launchType: String? = null

    private var networkConfiguration: GetTaskExecutionNetworkConfiguration? = null

    private var overrides: GetTaskExecutionOverrides? = null

    private var placementConstraints: List<GetTaskExecutionPlacementConstraint>? = null

    private var placementStrategies: List<GetTaskExecutionPlacementStrategy>? = null

    private var platformVersion: String? = null

    private var propagateTags: String? = null

    private var referenceId: String? = null

    private var startedBy: String? = null

    private var tags: Map<String, String>? = null

    private var taskDefinition: String? = null

    /**
     * @param value Set of capacity provider strategies to use for the cluster. See below.
     */
    @JvmName("djlgtxrpkkuopqak")
    public suspend
    fun capacityProviderStrategies(`value`: List<GetTaskExecutionCapacityProviderStrategy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Set of capacity provider strategies to use for the cluster. See below.
     */
    @JvmName("jbpfltiutwdbtsek")
    public suspend
    fun capacityProviderStrategies(argument: List<suspend GetTaskExecutionCapacityProviderStrategyBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionCapacityProviderStrategyBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Set of capacity provider strategies to use for the cluster. See below.
     */
    @JvmName("nvuokhtuhksewimd")
    public suspend fun capacityProviderStrategies(
        vararg
        argument: suspend GetTaskExecutionCapacityProviderStrategyBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionCapacityProviderStrategyBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Set of capacity provider strategies to use for the cluster. See below.
     */
    @JvmName("wylddhgmwprqsuds")
    public suspend
    fun capacityProviderStrategies(argument: suspend GetTaskExecutionCapacityProviderStrategyBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTaskExecutionCapacityProviderStrategyBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param values Set of capacity provider strategies to use for the cluster. See below.
     */
    @JvmName("wkbihkxurqbksauk")
    public suspend fun capacityProviderStrategies(
        vararg
        values: GetTaskExecutionCapacityProviderStrategy,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param value Short name or full Amazon Resource Name (ARN) of the cluster to run the task on.
     */
    @JvmName("rhfeqregacofqsrj")
    public suspend fun cluster(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cluster = mapped
    }

    /**
     * @param value Number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.
     */
    @JvmName("pkdafaatpcdqdojy")
    public suspend fun desiredCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.desiredCount = mapped
    }

    /**
     * @param value Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     */
    @JvmName("sylwfwixvibssnmy")
    public suspend fun enableEcsManagedTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableEcsManagedTags = mapped
    }

    /**
     * @param value Specifies whether to enable Amazon ECS Exec for the tasks within the service.
     */
    @JvmName("iwqxwgigvlgbhwro")
    public suspend fun enableExecuteCommand(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableExecuteCommand = mapped
    }

    /**
     * @param value Name of the task group to associate with the task. The default value is the family name of the task definition.
     */
    @JvmName("fpccgdaswuipgobg")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.group = mapped
    }

    /**
     * @param value Launch type on which to run your service. Valid values are `EC2`, `FARGATE`, and `EXTERNAL`.
     */
    @JvmName("yvghsriouiwssmoa")
    public suspend fun launchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.launchType = mapped
    }

    /**
     * @param value Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     */
    @JvmName("msisfxhhihviodjw")
    public suspend fun networkConfiguration(`value`: GetTaskExecutionNetworkConfiguration?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     */
    @JvmName("gcttgivexqyysuws")
    public suspend
    fun networkConfiguration(argument: suspend GetTaskExecutionNetworkConfigurationBuilder.() -> Unit) {
        val toBeMapped = GetTaskExecutionNetworkConfigurationBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.networkConfiguration = mapped
    }

    /**
     * @param value A list of container overrides that specify the name of a container in the specified task definition and the overrides it should receive.
     */
    @JvmName("spoqoyaicjgafbrr")
    public suspend fun overrides(`value`: GetTaskExecutionOverrides?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.overrides = mapped
    }

    /**
     * @param argument A list of container overrides that specify the name of a container in the specified task definition and the overrides it should receive.
     */
    @JvmName("lddkhjvgxfudhdeh")
    public suspend fun overrides(argument: suspend GetTaskExecutionOverridesBuilder.() -> Unit) {
        val toBeMapped = GetTaskExecutionOverridesBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.overrides = mapped
    }

    /**
     * @param value An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
     */
    @JvmName("ntyvgrkeuoebohbt")
    public suspend fun placementConstraints(`value`: List<GetTaskExecutionPlacementConstraint>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.placementConstraints = mapped
    }

    /**
     * @param argument An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
     */
    @JvmName("bugplkfpmyhtywho")
    public suspend
    fun placementConstraints(argument: List<suspend GetTaskExecutionPlacementConstraintBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionPlacementConstraintBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.placementConstraints = mapped
    }

    /**
     * @param argument An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
     */
    @JvmName("ahpybxhkvlyjlwvi")
    public suspend fun placementConstraints(
        vararg
        argument: suspend GetTaskExecutionPlacementConstraintBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionPlacementConstraintBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.placementConstraints = mapped
    }

    /**
     * @param argument An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
     */
    @JvmName("miabbbxlslvmrfop")
    public suspend
    fun placementConstraints(argument: suspend GetTaskExecutionPlacementConstraintBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTaskExecutionPlacementConstraintBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.placementConstraints = mapped
    }

    /**
     * @param values An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
     */
    @JvmName("hbhyimonntsdsbvl")
    public suspend fun placementConstraints(vararg values: GetTaskExecutionPlacementConstraint) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.placementConstraints = mapped
    }

    /**
     * @param value The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
     */
    @JvmName("plimvawjmwacuako")
    public suspend fun placementStrategies(`value`: List<GetTaskExecutionPlacementStrategy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.placementStrategies = mapped
    }

    /**
     * @param argument The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
     */
    @JvmName("wktnjytcqabsvbhe")
    public suspend
    fun placementStrategies(argument: List<suspend GetTaskExecutionPlacementStrategyBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionPlacementStrategyBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.placementStrategies = mapped
    }

    /**
     * @param argument The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
     */
    @JvmName("atcdiipghupmrqnh")
    public suspend fun placementStrategies(
        vararg
        argument: suspend GetTaskExecutionPlacementStrategyBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetTaskExecutionPlacementStrategyBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.placementStrategies = mapped
    }

    /**
     * @param argument The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
     */
    @JvmName("jbboxdkxptimqujd")
    public suspend
    fun placementStrategies(argument: suspend GetTaskExecutionPlacementStrategyBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTaskExecutionPlacementStrategyBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.placementStrategies = mapped
    }

    /**
     * @param values The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
     */
    @JvmName("icwqkcyorlaawmiw")
    public suspend fun placementStrategies(vararg values: GetTaskExecutionPlacementStrategy) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.placementStrategies = mapped
    }

    /**
     * @param value The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the `LATEST` platform version is used.
     */
    @JvmName("qbahfjwxetfwriyj")
    public suspend fun platformVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.platformVersion = mapped
    }

    /**
     * @param value Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. An error will be received if you specify the `SERVICE` option when running a task. Valid values are `TASK_DEFINITION` or `NONE`.
     */
    @JvmName("jwckvqatwakpwvrj")
    public suspend fun propagateTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.propagateTags = mapped
    }

    /**
     * @param value The reference ID to use for the task.
     */
    @JvmName("uoebmstvhtepvaeu")
    public suspend fun referenceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.referenceId = mapped
    }

    /**
     * @param value An optional tag specified when a task is started.
     */
    @JvmName("wgfniloitogjhuhp")
    public suspend fun startedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startedBy = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tfetfuemlyklykdq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xofxfoktkrmcoiaj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The `family` and `revision` (`family:revision`) or full ARN of the task definition to run. If a revision isn't specified, the latest `ACTIVE` revision is used.
     * The following arguments are optional:
     */
    @JvmName("jbkybcjnghoxgrhw")
    public suspend fun taskDefinition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.taskDefinition = mapped
    }

    internal fun build(): GetTaskExecutionPlainArgs = GetTaskExecutionPlainArgs(
        capacityProviderStrategies = capacityProviderStrategies,
        cluster = cluster ?: throw PulumiNullFieldException("cluster"),
        desiredCount = desiredCount,
        enableEcsManagedTags = enableEcsManagedTags,
        enableExecuteCommand = enableExecuteCommand,
        group = group,
        launchType = launchType,
        networkConfiguration = networkConfiguration,
        overrides = overrides,
        placementConstraints = placementConstraints,
        placementStrategies = placementStrategies,
        platformVersion = platformVersion,
        propagateTags = propagateTags,
        referenceId = referenceId,
        startedBy = startedBy,
        tags = tags,
        taskDefinition = taskDefinition ?: throw PulumiNullFieldException("taskDefinition"),
    )
}
