@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceLoadBalancerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName Name of the container to associate with the load balancer (as it appears in a container definition).
 * @property containerPort Port on the container to associate with the load balancer.
 * > **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
 * @property elbName Name of the ELB (Classic) to associate with the service.
 * @property targetGroupArn ARN of the Load Balancer target group to associate with the service.
 */
public data class ServiceLoadBalancerArgs(
    public val containerName: Output<String>,
    public val containerPort: Output<Int>,
    public val elbName: Output<String>? = null,
    public val targetGroupArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceLoadBalancerArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceLoadBalancerArgs =
        com.pulumi.aws.ecs.inputs.ServiceLoadBalancerArgs.builder()
            .containerName(containerName.applyValue({ args0 -> args0 }))
            .containerPort(containerPort.applyValue({ args0 -> args0 }))
            .elbName(elbName?.applyValue({ args0 -> args0 }))
            .targetGroupArn(targetGroupArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceLoadBalancerArgs].
 */
@PulumiTagMarker
public class ServiceLoadBalancerArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var containerPort: Output<Int>? = null

    private var elbName: Output<String>? = null

    private var targetGroupArn: Output<String>? = null

    /**
     * @param value Name of the container to associate with the load balancer (as it appears in a container definition).
     */
    @JvmName("aomsjppaceunjjco")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Port on the container to associate with the load balancer.
     * > **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
     */
    @JvmName("wepqssobjififrad")
    public suspend fun containerPort(`value`: Output<Int>) {
        this.containerPort = value
    }

    /**
     * @param value Name of the ELB (Classic) to associate with the service.
     */
    @JvmName("phjyerwiuffvmgrs")
    public suspend fun elbName(`value`: Output<String>) {
        this.elbName = value
    }

    /**
     * @param value ARN of the Load Balancer target group to associate with the service.
     */
    @JvmName("phbrwihfanodycqm")
    public suspend fun targetGroupArn(`value`: Output<String>) {
        this.targetGroupArn = value
    }

    /**
     * @param value Name of the container to associate with the load balancer (as it appears in a container definition).
     */
    @JvmName("padftqhodgknaahm")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Port on the container to associate with the load balancer.
     * > **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
     */
    @JvmName("orvmtyosmisygdxw")
    public suspend fun containerPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerPort = mapped
    }

    /**
     * @param value Name of the ELB (Classic) to associate with the service.
     */
    @JvmName("rxiylogaqflonpmo")
    public suspend fun elbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elbName = mapped
    }

    /**
     * @param value ARN of the Load Balancer target group to associate with the service.
     */
    @JvmName("qwyabgsfjlkegtmf")
    public suspend fun targetGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupArn = mapped
    }

    internal fun build(): ServiceLoadBalancerArgs = ServiceLoadBalancerArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        containerPort = containerPort ?: throw PulumiNullFieldException("containerPort"),
        elbName = elbName,
        targetGroupArn = targetGroupArn,
    )
}
