@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property assignPublicIp Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.
 * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
 * @property securityGroups Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
 * @property subnets Subnets associated with the task or service.
 */
public data class ServiceNetworkConfigurationArgs(
    public val assignPublicIp: Output<Boolean>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val subnets: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceNetworkConfigurationArgs =
        com.pulumi.aws.ecs.inputs.ServiceNetworkConfigurationArgs.builder()
            .assignPublicIp(assignPublicIp?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ServiceNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceNetworkConfigurationArgsBuilder internal constructor() {
    private var assignPublicIp: Output<Boolean>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.
     * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
     */
    @JvmName("bjoqyxhcuymgprlm")
    public suspend fun assignPublicIp(`value`: Output<Boolean>) {
        this.assignPublicIp = value
    }

    /**
     * @param value Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("nraaudowfltdoepa")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("lhyxmrdibhutmhdp")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("fdrerfhrrgxxyafn")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value Subnets associated with the task or service.
     */
    @JvmName("ffutuwvbaeqptpgv")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("pdrnminjsjbygtce")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values Subnets associated with the task or service.
     */
    @JvmName("sdnihrigpxyeomfn")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.
     * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
     */
    @JvmName("pxwmrfgfadhbonjj")
    public suspend fun assignPublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignPublicIp = mapped
    }

    /**
     * @param value Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("oeyirguwpcgbsdyi")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("sjyegrutnghyefyd")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value Subnets associated with the task or service.
     */
    @JvmName("lldfjlcurvrfcdbq")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values Subnets associated with the task or service.
     */
    @JvmName("dffvsifqyggnvdgm")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): ServiceNetworkConfigurationArgs = ServiceNetworkConfigurationArgs(
        assignPublicIp = assignPublicIp,
        securityGroups = securityGroups,
        subnets = subnets ?: throw PulumiNullFieldException("subnets"),
    )
}
