@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceOrderedPlacementStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property field For the `spread` placement strategy, valid values are `instanceId` (or `host`,
 * which has the same effect), or any platform or custom attribute that is applied to a container instance.
 * For the `binpack` type, valid values are `memory` and `cpu`. For the `random` type, this attribute is not
 * needed. For more information, see [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html).
 * > **Note:** for `spread`, `host` and `instanceId` will be normalized, by AWS, to be `instanceId`. This means the statefile will show `instanceId` but your config will differ if you use `host`.
 * @property type Type of placement strategy. Must be one of: `binpack`, `random`, or `spread`
 */
public data class ServiceOrderedPlacementStrategyArgs(
    public val `field`: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceOrderedPlacementStrategyArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceOrderedPlacementStrategyArgs =
        com.pulumi.aws.ecs.inputs.ServiceOrderedPlacementStrategyArgs.builder()
            .`field`(`field`?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceOrderedPlacementStrategyArgs].
 */
@PulumiTagMarker
public class ServiceOrderedPlacementStrategyArgsBuilder internal constructor() {
    private var `field`: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value For the `spread` placement strategy, valid values are `instanceId` (or `host`,
     * which has the same effect), or any platform or custom attribute that is applied to a container instance.
     * For the `binpack` type, valid values are `memory` and `cpu`. For the `random` type, this attribute is not
     * needed. For more information, see [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html).
     * > **Note:** for `spread`, `host` and `instanceId` will be normalized, by AWS, to be `instanceId`. This means the statefile will show `instanceId` but your config will differ if you use `host`.
     */
    @JvmName("smsamsjjeljjfdkd")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value Type of placement strategy. Must be one of: `binpack`, `random`, or `spread`
     */
    @JvmName("gfsnkowpxsxvuqjh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value For the `spread` placement strategy, valid values are `instanceId` (or `host`,
     * which has the same effect), or any platform or custom attribute that is applied to a container instance.
     * For the `binpack` type, valid values are `memory` and `cpu`. For the `random` type, this attribute is not
     * needed. For more information, see [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html).
     * > **Note:** for `spread`, `host` and `instanceId` will be normalized, by AWS, to be `instanceId`. This means the statefile will show `instanceId` but your config will differ if you use `host`.
     */
    @JvmName("guyjlhtyfovimfte")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value Type of placement strategy. Must be one of: `binpack`, `random`, or `spread`
     */
    @JvmName("hohgppxidwgbjypy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceOrderedPlacementStrategyArgs = ServiceOrderedPlacementStrategyArgs(
        `field` = `field`,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
