@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Specifies whether to use Service Connect with this service.
 * @property logConfiguration The log configuration for the container. See below.
 * @property namespace The namespace name or ARN of the `aws.servicediscovery.HttpNamespace` for use with Service Connect.
 * @property services The list of Service Connect service objects. See below.
 */
public data class ServiceServiceConnectConfigurationArgs(
    public val enabled: Output<Boolean>,
    public val logConfiguration: Output<ServiceServiceConnectConfigurationLogConfigurationArgs>? =
        null,
    public val namespace: Output<String>? = null,
    public val services: Output<List<ServiceServiceConnectConfigurationServiceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationArgs =
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .logConfiguration(logConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .services(
                services?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceServiceConnectConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceServiceConnectConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logConfiguration: Output<ServiceServiceConnectConfigurationLogConfigurationArgs>? =
        null

    private var namespace: Output<String>? = null

    private var services: Output<List<ServiceServiceConnectConfigurationServiceArgs>>? = null

    /**
     * @param value Specifies whether to use Service Connect with this service.
     */
    @JvmName("gfejwafrjlalyduc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The log configuration for the container. See below.
     */
    @JvmName("haywebekmtkagohi")
    public suspend
    fun logConfiguration(`value`: Output<ServiceServiceConnectConfigurationLogConfigurationArgs>) {
        this.logConfiguration = value
    }

    /**
     * @param value The namespace name or ARN of the `aws.servicediscovery.HttpNamespace` for use with Service Connect.
     */
    @JvmName("bytsqysijtxauuhh")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The list of Service Connect service objects. See below.
     */
    @JvmName("orpbgbqduleosljy")
    public suspend
    fun services(`value`: Output<List<ServiceServiceConnectConfigurationServiceArgs>>) {
        this.services = value
    }

    @JvmName("xppncitsqofwgvqw")
    public suspend fun services(
        vararg
        values: Output<ServiceServiceConnectConfigurationServiceArgs>,
    ) {
        this.services = Output.all(values.asList())
    }

    /**
     * @param values The list of Service Connect service objects. See below.
     */
    @JvmName("qevteljikyxkiqox")
    public suspend fun services(values: List<Output<ServiceServiceConnectConfigurationServiceArgs>>) {
        this.services = Output.all(values)
    }

    /**
     * @param value Specifies whether to use Service Connect with this service.
     */
    @JvmName("phadldgbafqduxwu")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The log configuration for the container. See below.
     */
    @JvmName("abmrmnewsovvltdq")
    public suspend
    fun logConfiguration(`value`: ServiceServiceConnectConfigurationLogConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfiguration = mapped
    }

    /**
     * @param argument The log configuration for the container. See below.
     */
    @JvmName("khijxtjciddalsbh")
    public suspend
    fun logConfiguration(argument: suspend ServiceServiceConnectConfigurationLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceServiceConnectConfigurationLogConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.logConfiguration = mapped
    }

    /**
     * @param value The namespace name or ARN of the `aws.servicediscovery.HttpNamespace` for use with Service Connect.
     */
    @JvmName("lisjrypctiwvwake")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The list of Service Connect service objects. See below.
     */
    @JvmName("ijlybrnwbentybxf")
    public suspend fun services(`value`: List<ServiceServiceConnectConfigurationServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param argument The list of Service Connect service objects. See below.
     */
    @JvmName("dxhingjuwhtndxtj")
    public suspend
    fun services(argument: List<suspend ServiceServiceConnectConfigurationServiceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceServiceConnectConfigurationServiceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param argument The list of Service Connect service objects. See below.
     */
    @JvmName("rmdftrktlcqqxaon")
    public suspend fun services(
        vararg
        argument: suspend ServiceServiceConnectConfigurationServiceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceServiceConnectConfigurationServiceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param argument The list of Service Connect service objects. See below.
     */
    @JvmName("ybcgqmvaomsvbpwi")
    public suspend
    fun services(argument: suspend ServiceServiceConnectConfigurationServiceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceServiceConnectConfigurationServiceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param values The list of Service Connect service objects. See below.
     */
    @JvmName("aleyfgkcfxahiasc")
    public suspend fun services(vararg values: ServiceServiceConnectConfigurationServiceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.services = mapped
    }

    internal fun build(): ServiceServiceConnectConfigurationArgs =
        ServiceServiceConnectConfigurationArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            logConfiguration = logConfiguration,
            namespace = namespace,
            services = services,
        )
}
