@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationLogConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property logDriver The log driver to use for the container.
 * @property options The configuration options to send to the log driver.
 * @property secretOptions The secrets to pass to the log configuration. See below.
 */
public data class ServiceServiceConnectConfigurationLogConfigurationArgs(
    public val logDriver: Output<String>,
    public val options: Output<Map<String, String>>? = null,
    public val secretOptions:
    Output<List<ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationLogConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationLogConfigurationArgs =
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationLogConfigurationArgs.builder()
            .logDriver(logDriver.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .secretOptions(
                secretOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceServiceConnectConfigurationLogConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceServiceConnectConfigurationLogConfigurationArgsBuilder internal constructor() {
    private var logDriver: Output<String>? = null

    private var options: Output<Map<String, String>>? = null

    private var secretOptions:
        Output<List<ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs>>? = null

    /**
     * @param value The log driver to use for the container.
     */
    @JvmName("rhooyeqlmowebyqd")
    public suspend fun logDriver(`value`: Output<String>) {
        this.logDriver = value
    }

    /**
     * @param value The configuration options to send to the log driver.
     */
    @JvmName("ngwugcalaonijjxd")
    public suspend fun options(`value`: Output<Map<String, String>>) {
        this.options = value
    }

    /**
     * @param value The secrets to pass to the log configuration. See below.
     */
    @JvmName("ditokphpxjxgfjig")
    public suspend
    fun secretOptions(`value`: Output<List<ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs>>) {
        this.secretOptions = value
    }

    @JvmName("apdvesphrskcytwk")
    public suspend fun secretOptions(
        vararg
        values: Output<ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs>,
    ) {
        this.secretOptions = Output.all(values.asList())
    }

    /**
     * @param values The secrets to pass to the log configuration. See below.
     */
    @JvmName("ynktjxmrvrhdxxpo")
    public suspend
    fun secretOptions(values: List<Output<ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs>>) {
        this.secretOptions = Output.all(values)
    }

    /**
     * @param value The log driver to use for the container.
     */
    @JvmName("mymefwhjfewxeeww")
    public suspend fun logDriver(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDriver = mapped
    }

    /**
     * @param value The configuration options to send to the log driver.
     */
    @JvmName("mnspkolposiekiyj")
    public suspend fun options(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param values The configuration options to send to the log driver.
     */
    @JvmName("fpoyjcvqnkqfrfvw")
    public fun options(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value The secrets to pass to the log configuration. See below.
     */
    @JvmName("jdusyrhuwcpvmuqw")
    public suspend
    fun secretOptions(`value`: List<ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretOptions = mapped
    }

    /**
     * @param argument The secrets to pass to the log configuration. See below.
     */
    @JvmName("kajdhnqrvudvltht")
    public suspend
    fun secretOptions(argument: List<suspend ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secretOptions = mapped
    }

    /**
     * @param argument The secrets to pass to the log configuration. See below.
     */
    @JvmName("yrgueeioeichvehw")
    public suspend fun secretOptions(
        vararg
        argument: suspend ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secretOptions = mapped
    }

    /**
     * @param argument The secrets to pass to the log configuration. See below.
     */
    @JvmName("ukigcomadcwxfphc")
    public suspend
    fun secretOptions(argument: suspend ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.secretOptions = mapped
    }

    /**
     * @param values The secrets to pass to the log configuration. See below.
     */
    @JvmName("sryslhgtbkucswfv")
    public suspend fun secretOptions(
        vararg
        values: ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretOptions = mapped
    }

    internal fun build(): ServiceServiceConnectConfigurationLogConfigurationArgs =
        ServiceServiceConnectConfigurationLogConfigurationArgs(
            logDriver = logDriver ?: throw PulumiNullFieldException("logDriver"),
            options = options,
            secretOptions = secretOptions,
        )
}
