@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the secret.
 * @property valueFrom The secret to expose to the container. The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
 */
public data class ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs(
    public val name: Output<String>,
    public val valueFrom: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs> {
    override fun toJava():
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs =
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .valueFrom(valueFrom.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs].
 */
@PulumiTagMarker
public class ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgsBuilder internal
constructor() {
    private var name: Output<String>? = null

    private var valueFrom: Output<String>? = null

    /**
     * @param value The name of the secret.
     */
    @JvmName("qlwobkoiommtwhld")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The secret to expose to the container. The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
     */
    @JvmName("rckeccdwufpecctv")
    public suspend fun valueFrom(`value`: Output<String>) {
        this.valueFrom = value
    }

    /**
     * @param value The name of the secret.
     */
    @JvmName("srshrulovvgblcnp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The secret to expose to the container. The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
     */
    @JvmName("nnlnyadfpdouponk")
    public suspend fun valueFrom(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueFrom = mapped
    }

    internal fun build(): ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs =
        ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            valueFrom = valueFrom ?: throw PulumiNullFieldException("valueFrom"),
        )
}
