@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clientAlias The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
 * @property discoveryName The name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
 * @property ingressPortOverride The port number for the Service Connect proxy to listen on.
 * @property portName The name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
 */
public data class ServiceServiceConnectConfigurationServiceArgs(
    public val clientAlias: Output<List<ServiceServiceConnectConfigurationServiceClientAliasArgs>>? =
        null,
    public val discoveryName: Output<String>? = null,
    public val ingressPortOverride: Output<Int>? = null,
    public val portName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceArgs =
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceArgs.builder()
            .clientAlias(
                clientAlias?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .discoveryName(discoveryName?.applyValue({ args0 -> args0 }))
            .ingressPortOverride(ingressPortOverride?.applyValue({ args0 -> args0 }))
            .portName(portName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceServiceConnectConfigurationServiceArgs].
 */
@PulumiTagMarker
public class ServiceServiceConnectConfigurationServiceArgsBuilder internal constructor() {
    private var clientAlias: Output<List<ServiceServiceConnectConfigurationServiceClientAliasArgs>>? =
        null

    private var discoveryName: Output<String>? = null

    private var ingressPortOverride: Output<Int>? = null

    private var portName: Output<String>? = null

    /**
     * @param value The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("ervbgxmhitvgkyme")
    public suspend
    fun clientAlias(`value`: Output<List<ServiceServiceConnectConfigurationServiceClientAliasArgs>>) {
        this.clientAlias = value
    }

    @JvmName("shmrhytahaepqrvg")
    public suspend fun clientAlias(
        vararg
        values: Output<ServiceServiceConnectConfigurationServiceClientAliasArgs>,
    ) {
        this.clientAlias = Output.all(values.asList())
    }

    /**
     * @param values The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("fsfgjntvrxvvpxls")
    public suspend
    fun clientAlias(values: List<Output<ServiceServiceConnectConfigurationServiceClientAliasArgs>>) {
        this.clientAlias = Output.all(values)
    }

    /**
     * @param value The name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
     */
    @JvmName("cbshjtwhdrobsvdh")
    public suspend fun discoveryName(`value`: Output<String>) {
        this.discoveryName = value
    }

    /**
     * @param value The port number for the Service Connect proxy to listen on.
     */
    @JvmName("yxcookgppdtvxato")
    public suspend fun ingressPortOverride(`value`: Output<Int>) {
        this.ingressPortOverride = value
    }

    /**
     * @param value The name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
     */
    @JvmName("vsubnrtycoedvbqi")
    public suspend fun portName(`value`: Output<String>) {
        this.portName = value
    }

    /**
     * @param value The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("lirumbgivaqfddvt")
    public suspend
    fun clientAlias(`value`: List<ServiceServiceConnectConfigurationServiceClientAliasArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAlias = mapped
    }

    /**
     * @param argument The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("okwabybgwlsxnlvv")
    public suspend
    fun clientAlias(argument: List<suspend ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clientAlias = mapped
    }

    /**
     * @param argument The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("vesnmaofwoqwohfb")
    public suspend fun clientAlias(
        vararg
        argument: suspend ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clientAlias = mapped
    }

    /**
     * @param argument The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("qcmpihscpbkxnglf")
    public suspend
    fun clientAlias(argument: suspend ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.clientAlias = mapped
    }

    /**
     * @param values The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("chjtrovvyeopitvd")
    public suspend fun clientAlias(
        vararg
        values: ServiceServiceConnectConfigurationServiceClientAliasArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientAlias = mapped
    }

    /**
     * @param value The name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
     */
    @JvmName("gvhaoxaxsanxafou")
    public suspend fun discoveryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveryName = mapped
    }

    /**
     * @param value The port number for the Service Connect proxy to listen on.
     */
    @JvmName("arincrcbnpiebvas")
    public suspend fun ingressPortOverride(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressPortOverride = mapped
    }

    /**
     * @param value The name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
     */
    @JvmName("kubigvdoatyuwdyi")
    public suspend fun portName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portName = mapped
    }

    internal fun build(): ServiceServiceConnectConfigurationServiceArgs =
        ServiceServiceConnectConfigurationServiceArgs(
            clientAlias = clientAlias,
            discoveryName = discoveryName,
            ingressPortOverride = ingressPortOverride,
            portName = portName ?: throw PulumiNullFieldException("portName"),
        )
}
